/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformer;

/**
 * The external form of a transformer.
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
abstract class Transformer extends AbstractExternalForm
                           implements ExternalTransformer {

	/**
	 * The attribute name used to store and retrieve the method property.
	 */
	static final String METHOD = "method";

	/**
	 * The attribute name used to store and retrieve the transformer-class property.
	 */
	static final String TRANSFORMER_CLASS = "transformer-class";

	/**
	 * Creates a new <code>Transformer</code>.
	 *
	 * @param parent The parent of this external form
	 */
	Transformer(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(TRANSFORMER_CLASS);
		names.add(METHOD);
		return names;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getMethodName() {
		return getAttribute(METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTransfomerClassName() {
		return getAttribute(TRANSFORMER_CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMethodName(String name) {
		setAttribute(METHOD, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTransformerClassName(String name) {
		setAttribute(TRANSFORMER_CLASS, name);
	}
}