/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.MultitenantType;
import org.eclipse.persistence.tools.mapping.orm.ExternalMultitenancyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

/**
 * The external form of the multitenant.
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class MultitenancyPolicy extends AbstractExternalForm
                               implements ExternalMultitenancyPolicy {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String MULTITENANT = "multitenant";

	/**
	 * The attribute name used to store and retrieve the type property.
	 */
	static final String TYPE = "type";

	/**
	 * Creates a new <code>MultitenancyPolicy</code>.
	 *
	 * @param parent The parent of this external form
	 */
	public MultitenancyPolicy(MappedSuperClassEntity parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalTenantDiscriminatorColumn addDiscriminatorColumn(int index) {
		TenantDiscriminatorColumn column = buildDiscriminatorColumn(index);
		column.addSelf();
		return column;
	}
	
	private TenantDiscriminatorColumn buildDiscriminatorColumn(int index) {
		return new TenantDiscriminatorColumn(this, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ListIterable<ExternalTenantDiscriminatorColumn> discriminatorColumns() {

		int count = discriminatorColumnSize();
		List<ExternalTenantDiscriminatorColumn> columns = new ArrayList<ExternalTenantDiscriminatorColumn>(count);

		for (int index = count; --index >= 0; )
		{
			ExternalTenantDiscriminatorColumn column = buildDiscriminatorColumn(index);
			columns.add(0, column);
		}

		return new ListListIterable<ExternalTenantDiscriminatorColumn>(columns);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int discriminatorColumnSize() {
		return getChildrenSize(TenantDiscriminatorColumn.TENANT_DISCRIMINATOR_COLUMN);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index) {

		Element element = getChild(TenantDiscriminatorColumn.TENANT_DISCRIMINATOR_COLUMN, index);

		if (element == null) {
			return null;
		}

		return buildDiscriminatorColumn(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return MULTITENANT;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MultitenantType getMultitenantType() {
		return getEnumAttribute(TYPE, MultitenantType.class);
	}

	public Element getParentEntityElement() {
		return getParentElement();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeDiscriminatorColumn(int index) {
		TenantDiscriminatorColumn column = buildDiscriminatorColumn(index);
		column.removeSelf();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMultitenantType(MultitenantType type) {
		setAttribute(TYPE, type);
	}
}