/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * This is an input stream that does nothing.
 * It returns nothing.
 * Performance should be pretty good....
 */
public final class NullInputStream
	extends InputStream
{
	// singleton
	private static InputStream INSTANCE = new NullInputStream();

	/**
	 * Return the singleton.
	 */
	public static synchronized InputStream instance() {
		return INSTANCE;
	}

	/**
	 * Ensure non-instantiability.
	 */
	private NullInputStream() {
		super();
	}

	@Override
	public int read() throws IOException {
		return -1;
	}

	@Override
	public int read(byte[] b) throws IOException {
		return -1;
	}

	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		return -1;
	}

	@Override
	public long skip(long n) throws IOException {
		return 0;
	}

	@Override
	public String toString() {
		return ObjectTools.singletonToString(this);
	}
}