/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence;

import java.util.ArrayList;
import org.eclipse.persistence.tools.utility.StringTools;

public enum PersistenceDocumentType {
    JPA_1_0("http://java.sun.com/xml/ns/persistence", "1.0", "http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd"),
    JPA_2_0("http://java.sun.com/xml/ns/persistence", "2.0", "http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd"),
    JPA_2_1("http://java.sun.com/xml/ns/persistence", "2.1", "http://java.sun.com/xml/ns/persistence/persistence_2_1.xsd"),
    UNKNOWN("http://java.sun.com/xml/ns/persistence", "2.0", "http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd");

    private String schemaURI;
    private String version;
    private String xmlNamespace;

    private PersistenceDocumentType(String xmlNamespace, String version, String schemaURI) {
        this.xmlNamespace = xmlNamespace;
        this.version = version;
        this.schemaURI = schemaURI;
    }

    public static Iterable<PersistenceDocumentType> types() {
        ArrayList<PersistenceDocumentType> types = new ArrayList<PersistenceDocumentType>(2);
        types.add(JPA_1_0);
        types.add(JPA_2_0);
        return types;
    }

    public static PersistenceDocumentType value(String xmlNamespace, String version, String schemaURI) {
        for (PersistenceDocumentType type : PersistenceDocumentType.types()) {
            if (!StringTools.equalsIgnoreCase((String)schemaURI, (String)type.schemaURI) && (!StringTools.equalsIgnoreCase((String)type.xmlNamespace, (String)xmlNamespace) || !StringTools.equalsIgnoreCase((String)type.version, (String)version))) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public String getVersion() {
        return this.version;
    }

    public String getXmlNamespace() {
        return this.xmlNamespace;
    }

    public String toString() {
        return this.version;
    }
}

