/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;
import org.eclipse.persistence.tools.utility.tests.TestTools;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TreeIterableTests
extends TestCase {
    Collection<TreeNode> nodes = new ArrayList<TreeNode>();

    public TreeIterableTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator1() {
        for (TreeNode tn : IterableTools.treeIterable((Object)this.buildTree(), this.buildTransformer())) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testIterator2() {
        for (TreeNode tn : IterableTools.treeIterable((Object[])new TreeNode[]{this.buildTree()}, this.buildTransformer())) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testToString() {
        TreeIterableTests.assertNotNull((Object)IterableTools.treeIterable((Object)this.buildTree(), this.buildTransformer()).toString());
    }

    private Transformer<TreeNode, Iterator<? extends TreeNode>> buildTransformer() {
        return new Transformer<TreeNode, Iterator<? extends TreeNode>>(){

            public Iterator<? extends TreeNode> transform(TreeNode next) {
                return next.children();
            }
        };
    }

    private TreeNode buildTree() {
        TreeNode root = new TreeNode("root");
        TreeNode child1 = new TreeNode(root, "child 1");
        new TreeNode(child1, "grandchild 1A");
        TreeNode child2 = new TreeNode(root, "child 2");
        new TreeNode(child2, "grandchild 2A");
        TreeNode grandchild2B = new TreeNode(child2, "grandchild 2B");
        new TreeNode(grandchild2B, "great-grandchild 2B1");
        new TreeNode(grandchild2B, "great-grandchild 2B2");
        TreeNode grandchild2C = new TreeNode(child2, "grandchild 2C");
        new TreeNode(grandchild2C, "great-grandchild 2C1");
        new TreeNode(root, "child 3");
        return root;
    }

    public class TreeNode {
        private String name;
        private Collection<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String name) {
            TreeIterableTests.this.nodes.add(this);
            this.name = name;
        }

        public TreeNode(TreeNode parent, String name) {
            this(name);
            parent.addChild(this);
        }

        public String getName() {
            return this.name;
        }

        private void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Iterator<TreeNode> children() {
            return this.children.iterator();
        }

        public int childrenSize() {
            return this.children.size();
        }

        public String toString() {
            return "TreeNode(" + this.name + ")";
        }
    }
}

