/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.Range;
import org.eclipse.persistence.tools.utility.ReverseComparator;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;
import org.eclipse.persistence.tools.utility.tests.ArrayToolsTests;

public class ListToolsTests
extends TestCase {
    public ListToolsTests(String name) {
        super(name);
    }

    public void testAddAllListIntObjectArray() {
        List<String> list = this.buildStringList1();
        ListTools.addAll(list, (int)2, (Object[])new String[]{"X", "X", "X"});
        ListToolsTests.assertEquals((int)6, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_Zero() {
        ArrayList list = new ArrayList();
        ListTools.addAll(list, (int)0, (Object[])new String[]{"X", "X", "X"});
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_EmptyArray() {
        List<String> list = this.buildStringList1();
        ListTools.addAll(list, (int)2, (Object[])new String[0]);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable() {
        List<String> list = this.buildStringList1();
        List<String> iterable = Arrays.asList("X", "X", "X");
        ListTools.addAll(list, (int)2, iterable);
        ListToolsTests.assertEquals((int)6, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable_Zero() {
        ArrayList list = new ArrayList();
        List<String> iterable = Arrays.asList("X", "X", "X");
        ListTools.addAll(list, (int)0, iterable);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterable_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        ListTools.addAll(list, (int)2, (Iterable)iterable);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt() {
        List<String> list = this.buildStringList1();
        List<String> iterable = Arrays.asList("X", "X", "X");
        ListTools.addAll(list, (int)2, iterable, (int)3);
        ListToolsTests.assertEquals((int)6, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_Zero() {
        ArrayList list = new ArrayList();
        List<String> iterable = Arrays.asList("X", "X", "X");
        ListTools.addAll(list, (int)0, iterable, (int)3);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        ListTools.addAll(list, (int)2, (Iterable)iterable, (int)0);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        ListTools.addAll(list, (int)2, iterator);
        ListToolsTests.assertEquals((int)6, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        ListTools.addAll(list, (int)0, iterator);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterator_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        ListTools.addAll(list, (int)2, (Iterator)iterator);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        ListTools.addAll(list, (int)2, iterator, (int)3);
        ListToolsTests.assertEquals((int)6, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        ListTools.addAll(list, (int)0, iterator, (int)3);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)list.contains("X"));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        ListTools.addAll(list, (int)2, (Iterator)iterator, (int)0);
        ListToolsTests.assertEquals((int)3, (int)list.size());
        ListToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testIndexOfDifference() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        ListToolsTests.assertEquals((int)3, (int)ListTools.indexOfDifference(list1, list2));
    }

    public void testLastIndexOfDifference() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        ListToolsTests.assertEquals((int)-1, (int)ListTools.lastIndexOfDifference(list1, list2));
    }

    public void testDifferenceRange() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        ListToolsTests.assertEquals((Object)new Range(3, -1), (Object)ListTools.differenceRange(list1, list2));
    }

    public void testFilterListFilter() {
        List<String> list = Arrays.asList("zero", "one", "two", "three", "four");
        ArrayList actual = ListTools.filter(list, (Filter)new ArrayToolsTests.StringLengthFilter(3));
        List<String> expected = Arrays.asList("one", "two");
        ListToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testFilterListFilterTransparent() {
        List<String> list = Arrays.asList("zero", "one", "two", "three", "four");
        ArrayList actual = ListTools.filter(list, (Filter)Filter.Transparent.instance());
        List<String> expected = Arrays.asList("zero", "one", "two", "three", "four");
        ListToolsTests.assertEquals(expected, (Object)actual);
        ListToolsTests.assertNotSame(expected, (Object)actual);
    }

    public void testIndexOfIdentityDifference() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        ListToolsTests.assertEquals((int)3, (int)ListTools.indexOfIdentityDifference(list1, list2));
    }

    public void testLastIndexOfIdentityDifference() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        ListToolsTests.assertEquals((int)-1, (int)ListTools.lastIndexOfIdentityDifference(list1, list2));
    }

    public void testIdentityDifferenceRange() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        ListToolsTests.assertEquals((Object)new Range(3, -1), (Object)ListTools.identityDifferenceRange(list1, list2));
    }

    public void testInsertionIndexOfListComparableRandomAccess() {
        List<String> list = Arrays.asList("A", "C", "D");
        ListToolsTests.assertEquals((int)1, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "C", "D");
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        ListToolsTests.assertEquals((int)4, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        ListToolsTests.assertEquals((int)6, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = Arrays.asList("B", "B", "B", "C", "D");
        ListToolsTests.assertEquals((int)0, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = Arrays.asList("A", "A", "B", "B", "C", "D");
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListComparableNonRandomAccess() {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("A", "C", "D"));
        ListToolsTests.assertEquals((int)1, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = new LinkedList<String>(Arrays.asList("A", "B", "C", "D"));
        ListToolsTests.assertEquals((int)1, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = new LinkedList<String>(Arrays.asList("A", "B", "B", "B", "C", "D"));
        ListToolsTests.assertEquals((int)1, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = new LinkedList<String>(Arrays.asList("A", "B", "B", "B", "C", "D"));
        ListToolsTests.assertEquals((int)6, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = new LinkedList<String>(Arrays.asList("B", "B", "B", "C", "D"));
        ListToolsTests.assertEquals((int)0, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = new LinkedList<String>(Arrays.asList("A", "A", "B", "B", "C", "D"));
        ListToolsTests.assertEquals((int)0, (int)ListTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListObjectComparatorRandomAccess() {
        ReverseComparator c = new ReverseComparator();
        List<String> list = Arrays.asList("D", "C", "A");
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "A");
        ListToolsTests.assertEquals((int)3, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        ListToolsTests.assertEquals((int)5, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        ListToolsTests.assertEquals((int)0, (int)ListTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B");
        ListToolsTests.assertEquals((int)5, (int)ListTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "A", "A");
        ListToolsTests.assertEquals((int)6, (int)ListTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testInsertionIndexOfListObjectComparatorNonRandomAccess() {
        ReverseComparator c = new ReverseComparator();
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("D", "C", "A"));
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = new LinkedList<String>(Arrays.asList("D", "C", "B", "A"));
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = new LinkedList<String>(Arrays.asList("D", "C", "B", "B", "B", "A"));
        ListToolsTests.assertEquals((int)2, (int)ListTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = new LinkedList<String>(Arrays.asList("D", "C", "B", "B", "B", "A"));
        ListToolsTests.assertEquals((int)0, (int)ListTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = new LinkedList<String>(Arrays.asList("D", "C", "B", "B", "B"));
        ListToolsTests.assertEquals((int)5, (int)ListTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = new LinkedList<String>(Arrays.asList("D", "C", "B", "B", "A", "A"));
        ListToolsTests.assertEquals((int)4, (int)ListTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testListIterable() {
        List<String> iterable = this.buildStringList1();
        ListToolsTests.assertEquals(this.buildStringList1(), (Object)ListTools.list(iterable));
    }

    public void testListIterableInt() {
        List<String> iterable = this.buildStringList1();
        ListToolsTests.assertEquals(this.buildStringList1(), (Object)ListTools.list(iterable, (int)3));
    }

    public void testListIterator_String() {
        ArrayList list = ListTools.list(this.buildStringList1().iterator());
        ListToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIterator_StringObject() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList list2 = ListTools.list(list1.iterator());
        ListToolsTests.assertEquals(list1, (Object)list2);
    }

    public void testListIterator_Empty() {
        ListToolsTests.assertEquals((int)0, (int)ListTools.list((Iterator)EmptyIterator.instance()).size());
    }

    public void testListIteratorInt() {
        ArrayList list = ListTools.list(this.buildStringList1().iterator(), (int)3);
        ListToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorInt_Empty() {
        ListToolsTests.assertEquals((int)0, (int)ListTools.list((Iterator)EmptyIterator.instance(), (int)5).size());
    }

    public void testListObjectArray() {
        ArrayList list = ListTools.list((Object[])this.buildStringArray1());
        ListToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testMoveListIntIntRandomAccess() {
        ArrayList list = new ArrayList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = ListTools.move(list, (int)4, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)5);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntSequentialAccess() {
        LinkedList list = new LinkedList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = ListTools.move(list, (int)4, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)5);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntIntRandomAccess() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = ListTools.move(list, (int)4, (int)2, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)5, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)1, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)0, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)1, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)0, (int)0);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testMoveListIntIntIntSequentialAccess() {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = ListTools.move(list, (int)4, (int)2, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)5, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = ListTools.move(list, (int)2, (int)4, (int)2);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)0, (int)1, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)0, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)1, (int)4);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = ListTools.move(list, (int)1, (int)0, (int)0);
        ListToolsTests.assertSame(list, (Object)result);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testRemoveElementsAtIndexListIntInt() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("A", "B", "A", "C", "A", "D"));
        ArrayList removed = ListTools.removeElementsAtIndex(list, (int)3, (int)2);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "D"}, list.toArray()));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"C", "A"}, removed.toArray()));
        list = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = ListTools.removeElementsAtIndex(list, (int)3, (int)3);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, list.toArray()));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, removed.toArray()));
        list = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = ListTools.removeElementsAtIndex(list, (int)0, (int)3);
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, list.toArray()));
        ListToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, removed.toArray()));
    }

    public void testRemoveDuplicateElementsList1() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        ListToolsTests.assertTrue((boolean)ListTools.removeDuplicateElements(list));
        int i = 0;
        ListToolsTests.assertEquals((String)"zero", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((String)"one", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((String)"two", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsList2() {
        Vector<String> list = this.buildStringVector1();
        ListToolsTests.assertFalse((boolean)ListTools.removeDuplicateElements(list));
        int i = 0;
        ListToolsTests.assertEquals((String)"zero", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((String)"one", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((String)"two", (String)((String)list.get(i++)));
        ListToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_Empty() {
        ArrayList list = new ArrayList();
        ListToolsTests.assertFalse((boolean)ListTools.removeDuplicateElements(list));
        ListToolsTests.assertEquals((int)0, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_SingleElement() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("zero");
        ListToolsTests.assertFalse((boolean)ListTools.removeDuplicateElements(list));
        ListToolsTests.assertEquals((int)1, (int)list.size());
    }

    public void testRotateList() {
        List actual = ListTools.rotate(this.buildStringList1());
        List<String> expected = this.buildStringList1();
        Collections.rotate(expected, 1);
        ListToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testTransformListTransformer() {
        List<String> list = Arrays.asList("zero", "one", "two");
        ArrayList actual = ListTools.transform(list, ArrayToolsTests.UPPER_CASE_TRANSFORMER);
        List<Object> expected = Arrays.asList("ZERO", "ONE", "TWO");
        ListToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testCopyListList() {
        List<String> src = this.buildStringList1();
        ArrayList<String> dest = new ArrayList<String>();
        for (String s : src) {
            dest.add(s.toUpperCase());
        }
        List result = ListTools.copy(dest, src);
        ListToolsTests.assertSame(dest, (Object)result);
    }

    public void testFillListObject() {
        List<String> list = this.buildStringList1();
        List result = ListTools.fill(list, (Object)"foo");
        ListToolsTests.assertSame(list, (Object)result);
        for (String string : result) {
            ListToolsTests.assertEquals((String)"foo", (String)string);
        }
    }

    public void testShuffleList() {
        List<String> list = this.buildStringList1();
        List result = ListTools.shuffle(list);
        ListToolsTests.assertSame(list, (Object)result);
    }

    public void testShuffleListRandom() {
        List<String> list = this.buildStringList1();
        List result = ListTools.shuffle(list, (Random)new Random());
        ListToolsTests.assertSame(list, (Object)result);
    }

    public void testSortList() {
        List<String> list = this.buildStringList1();
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        List result = ListTools.sort(list);
        ListToolsTests.assertSame(list, (Object)result);
    }

    public void testSwapListIntInt() {
        List<String> list = this.buildStringList1();
        List result = ListTools.swap(list, (int)0, (int)1);
        ListToolsTests.assertSame(list, (Object)result);
        List<String> original = this.buildStringList1();
        ListToolsTests.assertEquals((String)original.get(0), (String)((String)result.get(1)));
        ListToolsTests.assertEquals((String)original.get(1), (String)((String)result.get(0)));
        ListToolsTests.assertEquals((String)original.get(2), (String)((String)result.get(2)));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(ListTools.class);
                ListToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ListToolsTests.assertTrue((boolean)exCaught);
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }
}

