/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import java.util.Date;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;

public class DateSpinnerModelAdapter
extends SpinnerDateModel {
    private final Date defaultValue;
    private final ModifiablePropertyValueModel<Object> dateHolder;
    private final PropertyChangeListener dateChangeListener;
    private static final long serialVersionUID = 1L;

    public DateSpinnerModelAdapter(ModifiablePropertyValueModel<Object> dateHolder) {
        this(dateHolder, new Date());
    }

    public DateSpinnerModelAdapter(ModifiablePropertyValueModel<Object> dateHolder, Date defaultValue) {
        this(dateHolder, null, null, 5, defaultValue);
    }

    public DateSpinnerModelAdapter(ModifiablePropertyValueModel<Object> dateHolder, Comparable<?> start, Comparable<?> end, int calendarField) {
        this(dateHolder, start, end, calendarField, new Date());
    }

    public DateSpinnerModelAdapter(ModifiablePropertyValueModel<Object> dateHolder, Comparable<?> start, Comparable<?> end, int calendarField, Date defaultValue) {
        super(dateHolder.getValue() == null ? defaultValue : (Date)dateHolder.getValue(), start, end, calendarField);
        this.dateHolder = dateHolder;
        this.dateChangeListener = this.buildDateChangeListener();
        this.defaultValue = defaultValue;
    }

    protected PropertyChangeListener buildDateChangeListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildDateChangeListener_());
    }

    protected PropertyChangeListener buildDateChangeListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                DateSpinnerModelAdapter.this.synchronize(event.getNewValue());
            }

            public String toString() {
                return "date listener";
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.dateHolder.getValue()));
        }
        return super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.dateHolder.setValue(value);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.addPropertyChangeListener("value", this.dateChangeListener);
            this.synchronize(this.dateHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.dateHolder.removePropertyChangeListener("value", this.dateChangeListener);
        }
    }

    protected Date getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.dateHolder);
    }
}

