/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TransformationPropertyValueModel<V1, V2>
extends PropertyValueModelWrapper<V1>
implements PropertyValueModel<V2> {
    protected volatile V2 value;
    protected final Transformer<V1, V2> transformer;

    public TransformationPropertyValueModel(PropertyValueModel<? extends V1> valueModel) {
        super(valueModel);
        this.transformer = this.buildTransformer();
    }

    public TransformationPropertyValueModel(PropertyValueModel<? extends V1> valueModel, Transformer<V1, V2> transformer) {
        super(valueModel);
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
    }

    protected Transformer<V1, V2> buildTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public V2 getValue() {
        return this.value;
    }

    @Override
    protected void wrappedValueChanged(V1 oldValue, V1 newValue) {
        V2 old = this.value;
        this.value = this.transform(newValue);
        this.firePropertyChanged("value", old, this.value);
    }

    protected V2 transform(V1 v) {
        return this.transformer.transform(v);
    }

    protected V2 transform_(V1 v) {
        throw new RuntimeException("This method was not overridden.");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.value = this.transform(this.valueModel.getValue());
    }

    @Override
    protected void disengageModel() {
        this.value = null;
        super.disengageModel();
    }

    protected class DefaultTransformer
    implements Transformer<V1, V2> {
        protected DefaultTransformer() {
        }

        @Override
        public V2 transform(V1 v) {
            return v == null ? null : (Object)TransformationPropertyValueModel.this.transform_(v);
        }
    }
}

