/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.spi.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.db.relational.spi.ExternalColumn;
import org.eclipse.persistence.tools.db.relational.spi.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.db.relational.spi.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.db.relational.spi.jdbc.JDBCExternalForeignKey;
import org.eclipse.persistence.tools.utility.ObjectTools;

final class JDBCExternalForeignKeyColumnPair
implements ExternalForeignKeyColumnPair {
    private final JDBCExternalForeignKey foreignKey;
    private final ExternalColumn sourceColumn;
    private final ExternalColumn targetColumn;

    JDBCExternalForeignKeyColumnPair(JDBCExternalForeignKey foreignKey, ResultSet resultSet) {
        this.foreignKey = foreignKey;
        this.sourceColumn = this.columnNamed(this.stringFrom(resultSet, 8));
        this.targetColumn = this.buildLocalColumn(this.stringFrom(resultSet, 4));
    }

    private String stringFrom(ResultSet resultSet, int colIndex) {
        try {
            return this.trim(resultSet.getString(colIndex));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    @Override
    public ExternalColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    public ExternalColumn getTargetColumn() {
        return this.targetColumn;
    }

    private JDBCExternalColumn columnNamed(String columnName) {
        return this.foreignKey.columnNamed(columnName);
    }

    private ExternalColumn buildLocalColumn(String columnName) {
        return columnName == null ? null : new TargetColumn(columnName);
    }

    private String sourceColumnName() {
        return this.sourceColumn == null ? null : this.sourceColumn.getName();
    }

    private String targetColumnName() {
        return this.targetColumn == null ? null : this.targetColumn.getName();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (String)(String.valueOf(this.sourceColumnName()) + "=>" + this.targetColumnName()));
    }

    private static class TargetColumn
    implements ExternalColumn {
        private final String name;

        TargetColumn(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getJDBCTypeCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTypeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getScale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNullable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPrimaryKey() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (String)this.name);
        }
    }
}

