/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ShouldPrepareTest
extends AutoVerifyTestCase {
    private ReadObjectQuery query;
    private ReadObjectQuery queryCopy = new ReadObjectQuery();
    private Vector vec = new Vector();

    public ShouldPrepareTest() {
        this.setDescription("Test SQL prepared once option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        if (this.getSession().getPlatform().isDB2()) {
            throw new TestWarningException("This test is not supposed to work with DB2. " + Helper.cr() + "\t\tBecause as expected, sql string contains (t0.F_NAME = NULL) when the query is executed the second time with argument null, and '=NULL' is illegal syntax on DB2." + Helper.cr() + "\t\tHence, executing the query would result in runtime exception.");
        }
        this.query = (ReadObjectQuery)this.getSession().getDescriptor(Employee.class).getQueryManager().getQuery("shouldPrepareQuery");
        this.queryCopy = (ReadObjectQuery)this.query.clone();
        ExpressionBuilder ex = new ExpressionBuilder();
        this.queryCopy.setSelectionCriteria(ex.get("firstName").equal(ex.getParameter("firstName1")));
        this.queryCopy.addArgument("firstName1");
        this.vec = new Vector();
        this.vec.add("Bob");
        this.getSession().executeQuery((DatabaseQuery)this.queryCopy, (List)this.vec);
    }

    public void test() {
        this.vec.set(0, null);
        this.getSession().executeQuery((DatabaseQuery)this.queryCopy, (List)this.vec);
    }

    public void verify() {
        if (this.queryCopy.getCall().getSQLString().indexOf("NULL") != -1) {
            throw new TestErrorException("shouldPrepareTest failed, SQL was:" + this.queryCopy.getCall().getSQLString());
        }
    }
}

