/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;

public class ConcurrentRefreshOnCloneTest
extends AutoVerifyTestCase {
    public static ConcurrentAddress lock;
    public static ConcurrentAddress clone;
    public static ConcurrentAddress original;
    public static boolean cloneWaiting;
    public static boolean readerWaiting;
    public static boolean waited;
    public static int depth;
    public boolean toClone;
    public static Session session;
    int originalIsolationLevel;

    public ConcurrentRefreshOnCloneTest() {
    }

    public ConcurrentRefreshOnCloneTest(boolean toClone) {
        this.toClone = toClone;
    }

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork because of timing issues");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        session = this.getSession();
        waited = false;
        ConcurrentAddress newAddress = new ConcurrentAddress();
        newAddress.id = new BigDecimal(15);
        newAddress.city = "Meductic";
        newAddress.country = "Canada";
        newAddress.postalCode = "C1C 1C1";
        newAddress.province = "New Brunswick";
        newAddress.street = "St. Jermone";
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)newAddress);
        uow.commit();
        lock = newAddress;
        this.originalIsolationLevel = this.getSession().getLogin().getCacheTransactionIsolation();
        this.getSession().getLogin().setCacheTransactionIsolation(3);
    }

    public void test() {
        ConcurrentRefreshOnCloneTest.lock.city = "Some Large City";
        ConcurrentRefreshOnCloneTest.lock.country = "Some Small Country";
        ConcurrentRefreshOnCloneTest.lock.postalCode = "A1A 1A1";
        ConcurrentRefreshOnCloneTest.lock.province = "No Nation";
        ConcurrentRefreshOnCloneTest.lock.street = "No Name";
        original = (ConcurrentAddress)lock.clone();
        Vector<BigDecimal> primaryKey = new Vector<BigDecimal>(1);
        primaryKey.add(lock.getId());
        Thread thread1 = null;
        Thread thread2 = null;
        try {
            thread1 = new Thread(new ConcurrentRefreshOnCloneTest(true).runnable());
            thread1.start();
            thread2 = new Thread(new ConcurrentRefreshOnCloneTest(false).runnable());
            thread2.start();
        }
        catch (Exception ex) {
            System.out.println("Exception" + ex.toString());
        }
        try {
            thread1.join();
            thread2.join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.getAbstractSession().compareObjectsDontMatch((Object)lock, (Object)clone) && this.getAbstractSession().compareObjectsDontMatch((Object)original, (Object)clone)) {
            throw new TestErrorException("The test failed to clone the object without data corruption");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    if (ConcurrentRefreshOnCloneTest.this.toClone) {
                        UnitOfWork uow = session.acquireUnitOfWork();
                        clone = (ConcurrentAddress)uow.registerObject((Object)lock);
                    } else {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ReadObjectQuery query = new ReadObjectQuery(ConcurrentAddress.class);
                        query.setShouldRefreshIdentityMapResult(true);
                        query.setSelectionCriteria(new ExpressionBuilder().get("id").equal((Object)lock.getId()));
                        session.executeQuery((DatabaseQuery)query);
                        try {
                            if (lock == null) break block9;
                            ConcurrentAddress concurrentAddress = lock;
                            synchronized (concurrentAddress) {
                                lock.notifyAll();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)original);
        lock = null;
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getLogin().setCacheTransactionIsolation(this.originalIsolationLevel);
    }

    static {
        cloneWaiting = false;
        readerWaiting = false;
        waited = false;
    }
}

