/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.AggregateSystem;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.Client;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.Employee1;
import org.eclipse.persistence.testing.models.aggregate.EvaluationClient;
import org.eclipse.persistence.testing.models.aggregate.Transport;
import org.eclipse.persistence.testing.tests.aggregate.AddNullToAggregateCollectionTest;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderTablesTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateCollectionClearTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateCollectionMultipleUoWTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateCollectionOuterJoinTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateCollectionUoWTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateEventTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateInheritanceInitAggregateTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateInheritanceTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateInheritanceTypeFieldTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateInvalidationIdentityTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateMappingNullNotAllow;
import org.eclipse.persistence.testing.tests.aggregate.AggregateRelationshipsDirectCollectionTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateRelationshipsManyToManyTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateRelationshipsOneToManyTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateRelationshipsOneToOneTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateRelationshipsTargetOneToOneTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateTransientValueTestCase;
import org.eclipse.persistence.testing.tests.aggregate.AggregateVersionOpimisticLockingTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateWithOneToOneRelationshipTest;
import org.eclipse.persistence.testing.tests.aggregate.AggregateWithoutAttributesInheritanceTestCase;
import org.eclipse.persistence.testing.tests.aggregate.BatchReadingWithAggregateCollectionMapping;
import org.eclipse.persistence.testing.tests.aggregate.CheckForNullUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.aggregate.DescriptorRefreshCacheTest;
import org.eclipse.persistence.testing.tests.aggregate.InMemoryQueryKeyToAggregateTest;
import org.eclipse.persistence.testing.tests.aggregate.JoinInAggregateAndOwnerTest;
import org.eclipse.persistence.testing.tests.aggregate.MergingUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.aggregate.NestedAggregateCollectionAbstractTestCase;
import org.eclipse.persistence.testing.tests.aggregate.NestedAggregateCollectionTest;
import org.eclipse.persistence.testing.tests.aggregate.NestedAggregateTestCase;
import org.eclipse.persistence.testing.tests.aggregate.QueryKeyInAggregateInheritanceTest;
import org.eclipse.persistence.testing.tests.aggregate.QueryKeyInAggregateTest;
import org.eclipse.persistence.testing.tests.aggregate.TransformationMappingTest;
import org.eclipse.persistence.testing.tests.aggregate.UnitOfWorkCommitResumeTest;
import org.eclipse.persistence.testing.tests.aggregate.UnitOfWorkTest;
import org.eclipse.persistence.testing.tests.aggregate.VerifyCascadeDelete;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class AggregateTestModel
extends TestModel {
    public static boolean useNewAggregateCollection = true;

    public AggregateTestModel() {
        this.setDescription("This model tests reading/writing/deleting of the complex aggregate model.");
    }

    public AggregateTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addForcedRequiredSystems() {
        this.addForcedRequiredSystem(new AggregateSystem());
    }

    public void addRequiredSystems() {
    }

    public void addTests() {
        this.addTest((Test)AggregateTestModel.getReadObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getReadAllTestSuite());
        this.addTest((Test)AggregateTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getInsertObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getUnitOfWorkCommitResumeTestSuite());
        this.addTest((Test)AggregateTestModel.getCheckForNullUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getMergingUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getDescriptorPropertiesTestSuite());
        this.addTest((Test)AggregateTestModel.getEventTestSuite());
        this.addTest((Test)AggregateTestModel.getNestedAggregateTestSuite());
        this.addTest((Test)AggregateTestModel.getAggregateInheritanceTestSuite());
        this.addTest((Test)AggregateTestModel.getAggregateRelationshipsTestSuite());
    }

    public void addSRGTests() {
        this.addTest((Test)AggregateTestModel.getSRGReadObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGUpdateObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGReadAllTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGDeleteObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGInsertObjectTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGUnitOfWorkCommitResumeTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGCheckForNullUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGMergingUnitOfWorkTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGDescriptorPropertiesTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGEventTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGNestedAggregateTestSuite());
        this.addTest((Test)AggregateTestModel.getSRGAggregateInheritanceTestSuite());
    }

    public static TestSuite getAggregateInheritanceTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGAggregateInheritanceTestSuite();
        suite.addTest((Test)new AggregateInheritanceInitAggregateTestCase());
        return suite;
    }

    public static TestSuite getAggregateRelationshipsTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateRelationshipsTestSuite");
        suite.setDescription("This suite tests that aggregate relationships are handled correctly");
        suite.addTest((Test)new AggregateRelationshipsOneToOneTestCase());
        suite.addTest((Test)new AggregateRelationshipsTargetOneToOneTestCase());
        suite.addTest((Test)new AggregateRelationshipsOneToManyTestCase());
        suite.addTest((Test)new AggregateRelationshipsManyToManyTestCase());
        suite.addTest((Test)new AggregateRelationshipsDirectCollectionTestCase());
        return suite;
    }

    public static TestSuite getSRGAggregateInheritanceTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateInheritanceTestSuite");
        suite.setDescription("This suite test that aggregate inheritance is handled correctly");
        suite.addTest((Test)new AggregateInheritanceTestCase());
        suite.addTest((Test)new AggregateInheritanceTypeFieldTestCase());
        suite.addTest((Test)new AggregateWithoutAttributesInheritanceTestCase());
        suite.addTest((Test)new AggregateTransientValueTestCase());
        return suite;
    }

    public static TestSuite getCheckForNullUnitOfWorkTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGCheckForNullUnitOfWorkTestSuite();
        return suite;
    }

    public static TestSuite getSRGCheckForNullUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateCheckForNullUnitOfWorkTestSuite");
        suite.setDescription("This suite tests updating objects with UOW in the aggregate model.");
        Class<Employee> employeeClass = Employee.class;
        Class<Client> clientClass = Client.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new CheckForNullUnitOfWorkTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new CheckForNullUnitOfWorkTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new CheckForNullUnitOfWorkTest(manager.getObject(employeeClass, "example3")));
        return suite;
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGDeleteObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the aggregate model.");
        Class<Employee> employeeClass = Employee.class;
        Class<Client> clientClass = Client.class;
        Class<EvaluationClient> evaluationClientClass = EvaluationClient.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(clientClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(clientClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(clientClass, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(evaluationClientClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(evaluationClientClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(evaluationClientClass, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Agent.class, "example1")));
        suite.addTest((Test)new VerifyCascadeDelete(Agent.class));
        suite.addTest((Test)new AggregateCollectionClearTest(Agent.class));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new DeleteObjectTest(manager.getObject(Builder.class, "example1")));
            suite.addTest((Test)new VerifyCascadeDelete(Builder.class));
            suite.addTest((Test)new AggregateCollectionClearTest(Builder.class));
        }
        return suite;
    }

    public static TestSuite getDescriptorPropertiesTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGDescriptorPropertiesTestSuite();
        return suite;
    }

    public static TestSuite getSRGDescriptorPropertiesTestSuite() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        TestSuite suite = new TestSuite();
        suite.setName("AggregateDescriptorPropertiesTestSuite");
        suite.setDescription("This suite tests descriptor properties on the aggregate model.");
        suite.addTest((Test)new DescriptorRefreshCacheTest(manager.getObject(Employee.class, "example2")));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new AgentBuilderTablesTest());
        }
        return suite;
    }

    public static TestSuite getEventTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGEventTestSuite();
        return suite;
    }

    public static TestSuite getSRGEventTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateEventTestSuite");
        suite.setDescription("This suite test that aggregate events are being thrown appropiately");
        suite.addTest((Test)new AggregateEventTestCase());
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGInsertObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the aggregate model.");
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Client.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Client.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Client.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)EvaluationClient.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)EvaluationClient.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)EvaluationClient.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)Agent.example2()));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new InsertObjectTest((Object)Builder.example1()));
        }
        suite.addTest((Test)new AggregateMappingNullNotAllow());
        return suite;
    }

    public static TestSuite getMergingUnitOfWorkTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGMergingUnitOfWorkTestSuite();
        return suite;
    }

    public static TestSuite getSRGMergingUnitOfWorkTestSuite() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        TestSuite suite = new TestSuite();
        suite.setName("AggregateMergingUnitOfWorkTestSuite");
        suite.setDescription("This suite tests merging of objects from two UOWs in the aggregate model.");
        suite.addTest((Test)new MergingUnitOfWorkTest(manager.getObject(Employee.class, "example1")));
        return suite;
    }

    public static TestSuite getNestedAggregateTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGNestedAggregateTestSuite();
        return suite;
    }

    public static TestSuite getSRGNestedAggregateTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("NestedAggregateTestSuite");
        suite.setDescription("Tested that nested aggregates are handled properly.");
        suite.addTest((Test)new NestedAggregateTestCase());
        suite.addTest((Test)new NestedAggregateCollectionTest(Agent.class));
        suite.addTest((Test)new NestedAggregateCollectionAbstractTestCase(Agent.class));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new NestedAggregateCollectionTest(Builder.class));
            suite.addTest((Test)new NestedAggregateCollectionAbstractTestCase(Builder.class));
        }
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGReadAllTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the aggregate model.");
        suite.addTest((Test)new ReadAllTest(Employee1.class, 2));
        suite.addTest((Test)new ReadAllTest(Employee.class, 3));
        suite.addTest((Test)new ReadAllTest(Client.class, 3));
        suite.addTest((Test)new ReadAllTest(EvaluationClient.class, 3));
        suite.addTest((Test)new ReadAllTest(Agent.class, 1));
        suite.addTest((Test)new ReadAllTest(Transport.class, 4));
        suite.addTest((Test)new AggregateCollectionOuterJoinTest(Agent.class));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new ReadAllTest(Builder.class, 1));
            suite.addTest((Test)new AggregateCollectionOuterJoinTest(Builder.class));
        }
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGReadObjectTestSuite();
        suite.addTest((Test)new JoinInAggregateAndOwnerTest());
        suite.addTest((Test)new InMemoryQueryKeyToAggregateTest(true));
        suite.addTest((Test)new InMemoryQueryKeyToAggregateTest(false));
        suite.addTest((Test)new AggregateWithOneToOneRelationshipTest());
        suite.addTest((Test)new AggregateInvalidationIdentityTest());
        suite.addTest((Test)new QueryKeyInAggregateTest(true));
        suite.addTest((Test)new QueryKeyInAggregateTest(false));
        suite.addTest((Test)new QueryKeyInAggregateInheritanceTest());
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the aggregate model.");
        Class<Employee1> employee1Class = Employee1.class;
        Class<Employee> employeeClass = Employee.class;
        Class<Client> clientClass = Client.class;
        Class<EvaluationClient> evaluationClientClass = EvaluationClient.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employee1Class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employee1Class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(clientClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(clientClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(clientClass, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(evaluationClientClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(evaluationClientClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(evaluationClientClass, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Agent.class, "example1")));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new ReadObjectTest(manager.getObject(Builder.class, "example1")));
        }
        return suite;
    }

    public static TestSuite getUnitOfWorkCommitResumeTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGUnitOfWorkCommitResumeTestSuite();
        return suite;
    }

    public static TestSuite getSRGUnitOfWorkCommitResumeTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateUnitOfWorkCommitResumeTestSuite");
        suite.setDescription("This suite tests updating objects with UOW in the aggregate model using the commitAndResume method.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new BatchReadingWithAggregateCollectionMapping(Agent.class));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new BatchReadingWithAggregateCollectionMapping(Builder.class));
        }
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new UnitOfWorkCommitResumeTest(manager.getObject(employeeClass, "example3")));
        return suite;
    }

    public static TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGUnitOfWorkTestSuite();
        suite.addTest((Test)new AggregateVersionOpimisticLockingTest());
        return suite;
    }

    public static TestSuite getSRGUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateUnitOfWorkTestSuite");
        suite.setDescription("This suite tests updating objects with UOW in the aggregate model.");
        Class<Employee> employeeClass = Employee.class;
        Class<Client> clientClass = Client.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(employeeClass, "example3")));
        suite.addTest((Test)new AggregateCollectionUoWTest(manager.getObject(Agent.class, "example1")));
        suite.addTest((Test)new AggregateCollectionMultipleUoWTest(manager.getObject(Agent.class, "example1")));
        suite.addTest((Test)new TransformationMappingTest());
        suite.addTest((Test)new AddNullToAggregateCollectionTest((Agent)manager.getObject(Agent.class, "example1")));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new AggregateCollectionUoWTest(manager.getObject(Builder.class, "example1")));
            suite.addTest((Test)new AggregateCollectionMultipleUoWTest(manager.getObject(Builder.class, "example1")));
            suite.addTest((Test)new AddNullToAggregateCollectionTest((Builder)manager.getObject(Builder.class, "example1")));
        }
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = AggregateTestModel.getSRGUpdateObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("AggregateUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the aggregate model.");
        Class<Employee1> employee1Class = Employee1.class;
        Class<Employee> employeeClass = Employee.class;
        Class<Client> clientClass = Client.class;
        Class<EvaluationClient> evaluationClientClass = EvaluationClient.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employee1Class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employee1Class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employee1Class, "example2")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(clientClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(clientClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(clientClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(clientClass, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(evaluationClientClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(evaluationClientClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(evaluationClientClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(evaluationClientClass, "example3")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Agent.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Agent.class, "example1")));
        if (useNewAggregateCollection) {
            suite.addTest((Test)new WriteObjectTest(manager.getObject(Builder.class, "example1")));
            suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Builder.class, "example1")));
        }
        return suite;
    }
}

