/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import javax.persistence.Cache;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.jpa.JpaCache;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.AdvancedFetchGroupTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.ChestProtector;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.Gear;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.GoalieGear;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.NonPersistedSubclassOfChestProtector;
import org.eclipse.persistence.testing.models.jpa.advanced.fetchgroup.Pads;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTableCreator;
import org.eclipse.persistence.testing.models.jpa.metamodel.Manufacturer;
import org.eclipse.persistence.testing.models.jpa.xml.cacheable.CacheableTrueMappedSuperclass;
import org.eclipse.persistence.testing.models.jpa.xml.cacheable.SubCacheableFalseEntity;

public class CacheImplJUnitTest
extends JUnitTestCase {
    private static final String METAMODEL_PERSISTENCE_UNIT = "metamodel1";
    public static int ID_TEST_BASE = 3710;

    public CacheImplJUnitTest() {
    }

    public CacheImplJUnitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CacheImplJUnitTest");
        suite.addTest((Test)new CacheImplJUnitTest("testSetup"));
        suite.addTest((Test)new CacheImplJUnitTest("testContains"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClassObject"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClass"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictAll"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictContains"));
        suite.addTest((Test)new CacheImplJUnitTest("testCacheAPI"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClass_MappedSuperclass_RemovesAssignableSubclasses"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClassObject_MappedSuperclass_RemovesAssignableSubclasses"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClass_JavaLangClass_hasNoEffect"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClass_NonPersistableParentOfEntityMappedSuperclassChain_RemovesAssignableSubclasses"));
        suite.addTest((Test)new CacheImplJUnitTest("testEvictClass_NonPersistableSubclassOfEntityMappedSuperclassChain_hasNoEffect"));
        suite.addTest((Test)new CacheImplJUnitTest("testGetId_fromUnmanagedMappedSuperclass_handles_null_descriptor"));
        suite.addTest((Test)new CacheImplJUnitTest("testGetId_fromUnsupportedJavaLangInteger_throwsIAE_on_null_descriptor"));
        suite.addTest((Test)new CacheImplJUnitTest("testGetId_fromNativeMappedSuperclass_handles_null_cmp3policy_weaving_on"));
        return suite;
    }

    public String getPersistenceUnitName() {
        return "default1";
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new AdvancedFetchGroupTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new CacheableTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testContains() {
        EntityManager em1 = this.createEntityManager();
        this.beginTransaction(em1);
        Employee e1 = new Employee();
        e1.setFirstName("ellie1");
        e1.setId(Integer.valueOf(101));
        em1.persist((Object)e1);
        this.commitTransaction(em1);
        this.closeEntityManager(em1);
        boolean result = this.getEntityManagerFactory().getCache().contains(Employee.class, (Object)101);
        CacheImplJUnitTest.assertTrue((String)"Employee not found in cache", (boolean)result);
    }

    public void testCacheAPI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName("testCacheAPI");
        em.persist((Object)employee);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        JpaCache cache = (JpaCache)this.getEntityManagerFactory().getCache();
        CacheImplJUnitTest.assertTrue((String)"Employee not valid in cache", (boolean)cache.isValid((Object)employee));
        CacheImplJUnitTest.assertTrue((String)"Employee not valid in cache", (boolean)cache.isValid(Employee.class, (Object)employee.getId()));
        cache.timeToLive((Object)employee);
        CacheImplJUnitTest.assertTrue((String)"Employee not found in cache", (cache.getObject(Employee.class, (Object)employee.getId()) != null ? 1 : 0) != 0);
        CacheImplJUnitTest.assertTrue((String)"Employee not found in cache", (boolean)cache.contains((Object)employee));
        cache.evict((Object)employee);
        cache.putObject((Object)employee);
        cache.print();
        cache.removeObject((Object)employee);
        cache.removeObject(Employee.class, (Object)employee.getId());
        cache.clear();
        cache.clear(Employee.class);
        cache.clearQueryCache();
        cache.clearQueryCache("findAllEmployeesByIdAndFirstName");
        CacheImplJUnitTest.assertTrue((String)"Employee id not correct", (boolean)employee.getId().equals(cache.getId((Object)employee)));
        cache.print();
        cache.print(Employee.class);
        cache.printLocks();
        cache.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClassObject() {
        EntityManager em2 = this.createEntityManager();
        this.beginTransaction(em2);
        Employee e2 = new Employee();
        e2.setFirstName("ellie");
        e2.setId(Integer.valueOf(121));
        em2.persist((Object)e2);
        this.commitTransaction(em2);
        this.closeEntityManager(em2);
        EntityManager em3 = this.createEntityManager();
        EntityManager em4 = this.createEntityManager();
        try {
            Employee emp1 = (Employee)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e2);
            emp1.setFirstName("foo");
            String beforeCache = ((Employee)em3.find(Employee.class, (Object)121)).getFirstName();
            this.getEntityManagerFactory().getCache().evict(Employee.class, (Object)121);
            Employee e3 = (Employee)em4.find(Employee.class, (Object)121);
            String afterCache = e3.getFirstName();
            CacheImplJUnitTest.assertNotSame((String)"Assertion Error", (Object)beforeCache, (Object)afterCache);
        }
        finally {
            this.closeEntityManager(em3);
            this.closeEntityManager(em4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClass() {
        EntityManager em5 = this.createEntityManager();
        this.beginTransaction(em5);
        Employee e4 = new Employee();
        e4.setFirstName("ellie");
        e4.setId(Integer.valueOf(131));
        em5.persist((Object)e4);
        this.commitTransaction(em5);
        this.closeEntityManager(em5);
        EntityManager em6 = this.createEntityManager();
        EntityManager em7 = this.createEntityManager();
        try {
            Employee emp2 = (Employee)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e4);
            emp2.setFirstName("food");
            String expected = ((Employee)em6.find(Employee.class, (Object)131)).getFirstName();
            this.getEntityManagerFactory().getCache().evict(Employee.class);
            Employee e5 = (Employee)em7.find(Employee.class, (Object)131);
            String actual = e5.getFirstName();
            CacheImplJUnitTest.assertNotSame((String)"Assertion Error", (Object)expected, (Object)actual);
        }
        finally {
            this.closeEntityManager(em6);
            this.closeEntityManager(em7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictAll() {
        EntityManager em8 = this.createEntityManager();
        this.beginTransaction(em8);
        Employee e6 = new Employee();
        e6.setFirstName("ellie");
        e6.setId(Integer.valueOf(141));
        Department d1 = new Department();
        d1.setId(Integer.valueOf(3));
        d1.setName("Computers");
        em8.persist((Object)d1);
        em8.persist((Object)e6);
        this.commitTransaction(em8);
        String expectedEmp = e6.getFirstName();
        String expectedDept = d1.getName();
        this.closeEntityManager(em8);
        EntityManager em9 = this.createEntityManager();
        try {
            Employee emp3 = (Employee)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e6);
            Department dept1 = (Department)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)d1);
            emp3.setFirstName("foo");
            dept1.setName("science");
            this.getEntityManagerFactory().getCache().evictAll();
            Employee e4 = (Employee)em9.find(Employee.class, (Object)141);
            String actualEmp = e4.getFirstName();
            Department d2 = (Department)em9.find(Department.class, (Object)3);
            String actualDept = d2.getName();
            CacheImplJUnitTest.assertEquals((String)"Assertion Error", (String)expectedEmp, (String)actualEmp);
            CacheImplJUnitTest.assertEquals((String)"Assertion Error", (String)expectedDept, (String)actualDept);
        }
        finally {
            this.closeEntityManager(em9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictContains() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("evictContains");
        em.persist((Object)emp);
        this.commitTransaction(em);
        try {
            CacheImplJUnitTest.assertTrue((boolean)em.getEntityManagerFactory().getCache().contains(Employee.class, (Object)emp.getId()));
            em.clear();
            Employee findEmp = (Employee)em.find(Employee.class, (Object)emp.getId());
            CacheImplJUnitTest.assertNotNull((Object)findEmp);
            em.getEntityManagerFactory().getCache().evict(Employee.class, (Object)emp.getId());
            CacheImplJUnitTest.assertFalse((boolean)em.getEntityManagerFactory().getCache().contains(Employee.class, (Object)emp.getId()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClass_MappedSuperclass_RemovesAssignableSubclasses() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID_PADS = ID_TEST_BASE + 2100;
            int ID_CHESTPROTECTOR = ID_PADS++;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            ChestProtector e1 = new ChestProtector();
            e1.setDescription("chest_protector");
            e1.setSerialNumber(new Integer(ID_PADS));
            em.persist((Object)e1);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Pads p1 = new Pads();
            p1.setDescription("pads");
            p1.setSerialNumber(new Integer(ID_CHESTPROTECTOR));
            em.persist((Object)p1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            try {
                ChestProtector e2 = (ChestProtector)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e1);
                Pads p2 = (Pads)((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession().getIdentityMapAccessor().getFromIdentityMap((Object)p1);
                e2.setDescription("new_chest_protector");
                p2.setDescription("new_pads");
                String expected_chestProtector = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR)).getDescription();
                String expected_pads = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_PADS)).getDescription();
                this.getEntityManagerFactory().getCache().evict(GoalieGear.class);
                GoalieGear g5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR);
                GoalieGear p5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_PADS);
                String actual_chestProtector = g5.getDescription();
                String actual_pads = p5.getDescription();
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_chestProtector, (Object)actual_chestProtector);
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_pads, (Object)actual_pads);
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClass_NonPersistableParentOfEntityMappedSuperclassChain_RemovesAssignableSubclasses() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID_PADS = ID_TEST_BASE + 800;
            int ID_CHESTPROTECTOR = ID_PADS++;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            ChestProtector e1 = new ChestProtector();
            e1.setDescription("chest_protector");
            e1.setSerialNumber(new Integer(ID_PADS));
            em.persist((Object)e1);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Pads p1 = new Pads();
            p1.setDescription("pads");
            p1.setSerialNumber(new Integer(ID_CHESTPROTECTOR));
            em.persist((Object)p1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            try {
                ChestProtector e2 = (ChestProtector)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e1);
                Pads p2 = (Pads)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)p1);
                e2.setDescription("new_chest_protector");
                p2.setDescription("new_pads");
                String expected_chestProtector = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR)).getDescription();
                String expected_pads = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_PADS)).getDescription();
                this.getEntityManagerFactory().getCache().evict(Gear.class);
                GoalieGear g5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR);
                GoalieGear p5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_PADS);
                String actual_chestProtector = g5.getDescription();
                String actual_pads = p5.getDescription();
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_chestProtector, (Object)actual_chestProtector);
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_pads, (Object)actual_pads);
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClass_NonPersistableSubclassOfEntityMappedSuperclassChain_hasNoEffect() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID_PADS = ID_TEST_BASE + 900;
            int ID_CHESTPROTECTOR = ID_PADS++;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            ChestProtector e1 = new ChestProtector();
            e1.setDescription("chest_protector");
            e1.setSerialNumber(new Integer(ID_PADS));
            em.persist((Object)e1);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Pads p1 = new Pads();
            p1.setDescription("pads");
            p1.setSerialNumber(new Integer(ID_CHESTPROTECTOR));
            em.persist((Object)p1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            try {
                ChestProtector e2 = (ChestProtector)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e1);
                Pads p2 = (Pads)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)p1);
                e2.setDescription("new_chest_protector");
                p2.setDescription("new_pads");
                String expected_chestProtector = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR)).getDescription();
                String expected_pads = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_PADS)).getDescription();
                this.getEntityManagerFactory().getCache().evict(NonPersistedSubclassOfChestProtector.class);
                GoalieGear g5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR);
                GoalieGear p5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_PADS);
                String actual_chestProtector = g5.getDescription();
                String actual_pads = p5.getDescription();
                CacheImplJUnitTest.assertSame((String)"Assertion Error - There should be a modified cached entity instance in the cache - the entity is not actually read from the database", (Object)expected_pads, (Object)actual_pads);
                CacheImplJUnitTest.assertSame((String)"Assertion Error - There should be a modified cached entity instance in the cache - the entity is not actually read from the database", (Object)expected_chestProtector, (Object)actual_chestProtector);
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClassObject_MappedSuperclass_RemovesAssignableSubclasses() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID_PADS = ID_TEST_BASE + 200;
            int ID_CHESTPROTECTOR = ID_PADS++;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            ChestProtector e1 = new ChestProtector();
            e1.setDescription("chest_protector");
            e1.setSerialNumber(new Integer(ID_PADS));
            em.persist((Object)e1);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Pads p1 = new Pads();
            p1.setDescription("pads");
            p1.setSerialNumber(new Integer(ID_CHESTPROTECTOR));
            em.persist((Object)p1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            try {
                GoalieGear c2 = (GoalieGear)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e1);
                Pads p2 = (Pads)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)p1);
                c2.setDescription("new_chest_protector");
                p2.setDescription("new_pads");
                String expected_chestProtector = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR)).getDescription();
                String expected_pads = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID_PADS)).getDescription();
                this.getEntityManagerFactory().getCache().evict(GoalieGear.class, (Object)c2.getSerialNumber());
                this.getEntityManagerFactory().getCache().evict(GoalieGear.class, (Object)p2.getSerialNumber());
                GoalieGear c5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_CHESTPROTECTOR);
                GoalieGear p5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID_PADS);
                String actual_chestProtector = c5.getDescription();
                String actual_pads = p5.getDescription();
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_chestProtector, (Object)actual_chestProtector);
                CacheImplJUnitTest.assertNotSame((String)"Assertion Error - There should be no modified cached entity instance in the cache - the entity read from the database should be different. ", (Object)expected_pads, (Object)actual_pads);
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEvictClass_JavaLangClass_hasNoEffect() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID = ID_TEST_BASE + 300;
            boolean _exceptionThrown = false;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            ChestProtector e1 = new ChestProtector();
            e1.setDescription("gear");
            e1.setSerialNumber(new Integer(ID));
            em.persist((Object)e1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            try {
                GoalieGear e2 = (GoalieGear)this.getDatabaseSession().getIdentityMapAccessor().getFromIdentityMap((Object)e1);
                e2.setDescription("new_gear");
                String expected = ((GoalieGear)em1.find(GoalieGear.class, (Object)ID)).getDescription();
                this.getEntityManagerFactory().getCache().evict(Integer.class);
                GoalieGear g5 = (GoalieGear)em2.find(GoalieGear.class, (Object)ID);
                String actual = g5.getDescription();
                CacheImplJUnitTest.assertSame((String)"Assertion Error - There should be a modified cached entity instance in the cache - the entity is not actually read from the database", (Object)expected, (Object)actual);
            }
            catch (IllegalArgumentException iae) {
                _exceptionThrown = true;
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
                CacheImplJUnitTest.assertFalse((String)"IllegalArgumentException was thrown.", (boolean)_exceptionThrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId_fromUnmanagedMappedSuperclass_handles_null_descriptor() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID = ID_TEST_BASE + 400;
            boolean _exceptionThrown = false;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            SubCacheableFalseEntity anEntity = new SubCacheableFalseEntity();
            CacheableTrueMappedSuperclass aMappedSuperclass = new CacheableTrueMappedSuperclass();
            anEntity.setId(ID);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            EntityManager em2 = this.createEntityManager();
            Cache aJPACache = this.getEntityManagerFactory().getCache();
            JpaCache anEclipseLinkCache = (JpaCache)this.getEntityManagerFactory().getCache();
            Object anId = null;
            try {
                anId = anEclipseLinkCache.getId((Object)anEntity);
            }
            catch (IllegalArgumentException iae) {
                _exceptionThrown = true;
            }
            finally {
                this.closeEntityManager(em1);
                this.closeEntityManager(em2);
                CacheImplJUnitTest.assertTrue((String)"IllegalArgumentException should have been thrown on the unmanaged entity lacking a descriptor.", (boolean)_exceptionThrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId_fromUnsupportedJavaLangInteger_throwsIAE_on_null_descriptor() {
        if (!CacheImplJUnitTest.isJPA10()) {
            boolean _exceptionThrown = false;
            EntityManager em1 = this.createEntityManager();
            JpaCache anEclipseLinkCache = (JpaCache)this.getEntityManagerFactory().getCache();
            try {
                anEclipseLinkCache.getId((Object)new Integer(1));
            }
            catch (IllegalArgumentException iae) {
                _exceptionThrown = true;
            }
            finally {
                this.closeEntityManager(em1);
                CacheImplJUnitTest.assertTrue((String)"IllegalArgumentException should have been thrown on a getId() call on an Integer which obviously has no descriptor.", (boolean)_exceptionThrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId_fromNativeMappedSuperclass_handles_null_cmp3policy_weaving_on() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID = ID_TEST_BASE + 500;
            Integer originalId = null;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            org.eclipse.persistence.testing.models.jpa.cacheable.SubCacheableFalseEntity anEntity = new org.eclipse.persistence.testing.models.jpa.cacheable.SubCacheableFalseEntity();
            org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTrueMappedSuperclass aMappedSuperclass = new org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTrueMappedSuperclass();
            anEntity.setId(ID);
            em.persist((Object)anEntity);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = this.createEntityManager();
            JpaCache anEclipseLinkCache = (JpaCache)this.getEntityManagerFactory().getCache();
            Object anId = null;
            originalId = anEntity.getId();
            ClassDescriptor cdesc = ((EntityManagerImpl)em1).getSession().getClassDescriptor(anEntity.getClass());
            CMP3Policy policy = (CMP3Policy)cdesc.getCMPPolicy();
            CacheImplJUnitTest.assertNotNull((String)"CMP3Policy should exist", (Object)policy);
            cdesc.setCMPPolicy(null);
            try {
                anId = anEclipseLinkCache.getId((Object)anEntity);
                CacheImplJUnitTest.assertNotNull((String)"Id instance should not be null", (Object)anId);
                CacheImplJUnitTest.assertTrue((String)"Id instance should be of type Integer", (boolean)(anId instanceof Integer));
                CacheImplJUnitTest.assertEquals((int)((Integer)anId), (int)ID);
                CacheImplJUnitTest.assertEquals((Object)anId, (Object)originalId);
            }
            finally {
                cdesc.setCMPPolicy((CMPPolicy)policy);
                this.closeEntityManager(em1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId_fromNativeMappedSuperclass_handles_null_cmp3policy_and_null_pk_with_weaving_on() {
        if (!CacheImplJUnitTest.isJPA10()) {
            Object ID = null;
            Integer originalId = null;
            EntityManager em = CacheImplJUnitTest.createEntityManager((String)METAMODEL_PERSISTENCE_UNIT);
            this.beginTransaction(em);
            Manufacturer anEntity = new Manufacturer();
            em.persist((Object)anEntity);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManager em1 = CacheImplJUnitTest.createEntityManager((String)METAMODEL_PERSISTENCE_UNIT);
            JpaCache anEclipseLinkCache = (JpaCache)CacheImplJUnitTest.getEntityManagerFactory((String)METAMODEL_PERSISTENCE_UNIT).getCache();
            Object anId = null;
            originalId = anEntity.getId();
            ClassDescriptor cdesc = ((EntityManagerImpl)em1).getSession().getClassDescriptor(anEntity.getClass());
            CMP3Policy policy = (CMP3Policy)cdesc.getCMPPolicy();
            CacheImplJUnitTest.assertNotNull((String)"CMP3Policy should exist prior to having been cleared manually for this test", (Object)policy);
            cdesc.setCMPPolicy(null);
            try {
                anId = anEclipseLinkCache.getId((Object)anEntity);
                CacheImplJUnitTest.assertNotNull((String)"Id instance should not be null", (Object)anId);
                CacheImplJUnitTest.assertTrue((String)"Id instance should be of type Integer", (boolean)(anId instanceof Integer));
                CacheImplJUnitTest.assertEquals((Object)anId, (Object)originalId);
            }
            finally {
                cdesc.setCMPPolicy((CMPPolicy)policy);
                this.closeEntityManager(em1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId_fromNativeMappedSuperclass_handles_null_cmp3policy_and_null_pk_with_weaving_off() {
        if (!CacheImplJUnitTest.isJPA10()) {
            int ID = ID_TEST_BASE + 700;
            Integer originalId = null;
            EntityManager em = CacheImplJUnitTest.createEntityManager((String)METAMODEL_PERSISTENCE_UNIT);
            this.beginTransaction(em);
            Manufacturer anEntity = new Manufacturer();
            anEntity.setName("test");
            anEntity.setId(Integer.valueOf(ID));
            em.persist((Object)anEntity);
            this.commitTransaction(em);
            EntityManager em1 = CacheImplJUnitTest.createEntityManager((String)METAMODEL_PERSISTENCE_UNIT);
            JpaCache anEclipseLinkCache = (JpaCache)CacheImplJUnitTest.getEntityManagerFactory((String)METAMODEL_PERSISTENCE_UNIT).getCache();
            Object anId = null;
            originalId = anEntity.getId();
            ClassDescriptor cdesc = ((EntityManagerImpl)em).getSession().getClassDescriptor(anEntity.getClass());
            CacheImplJUnitTest.assertNotNull((String)"ClassDescriptor for Entity must not be null", (Object)cdesc);
            CMP3Policy policy = (CMP3Policy)cdesc.getCMPPolicy();
            CacheImplJUnitTest.assertNotNull((String)"CMP3Policy should exist prior to having been cleared manually for this test", (Object)policy);
            cdesc.setCMPPolicy(null);
            try {
                anId = anEclipseLinkCache.getId((Object)anEntity);
                CacheImplJUnitTest.assertNotNull((String)"Id instance should not be null", (Object)anId);
                CacheImplJUnitTest.assertTrue((String)"Id instance should be of type Integer", (boolean)(anId instanceof Integer));
                CacheImplJUnitTest.assertEquals((Object)anId, (Object)ID);
                CacheImplJUnitTest.assertEquals((Object)anId, (Object)originalId);
            }
            finally {
                cdesc.setCMPPolicy((CMPPolicy)policy);
                this.closeEntityManager(em1);
                this.closeEntityManager(em);
            }
        }
    }
}

