/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXFragmentBuilder
extends SAXDocumentBuilder {
    private UnmarshalRecord owningRecord;

    public SAXFragmentBuilder(UnmarshalRecord unmarshalRecord) {
        this.owningRecord = unmarshalRecord;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String prefix;
        boolean bufferContainsOnlyWhitespace;
        boolean bl = bufferContainsOnlyWhitespace = this.stringBuffer.toString().trim().length() == 0;
        if (bufferContainsOnlyWhitespace) {
            this.stringBuffer.reset();
        }
        if (this.stringBuffer.length() > 0 && this.nodes.size() != 1) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            Node parent = (Node)this.nodes.get(this.nodes.size() - 1);
            parent.appendChild(text);
            this.processNamespacesForText(text.getTextContent(), (Element)parent);
            this.stringBuffer.reset();
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if (qName == null) {
            String prefix2;
            qName = localName;
            if (namespaceURI != null && this.owningRecord != null && (prefix2 = this.owningRecord.resolveNamespaceUri(namespaceURI)) != null && prefix2.length() > 0) {
                qName = String.valueOf(prefix2) + ':' + qName;
            }
        }
        int qNameColonIndex = qName.indexOf(58);
        if (namespaceURI != null && qNameColonIndex == -1 && (prefix = this.owningRecord.resolveNamespaceUri(namespaceURI)) != null && prefix.length() > 0) {
            qName = String.valueOf(prefix) + ':' + qName;
            qNameColonIndex = prefix.length();
        }
        Element element = this.getInitializedDocument().createElementNS(namespaceURI, qName);
        Node parentNode = (Node)this.nodes.get(this.nodes.size() - 1);
        this.appendChildNode(parentNode, element);
        this.nodes.add(element);
        if (qNameColonIndex > -1) {
            String prefix3 = qName.substring(0, qNameColonIndex);
            String parentUri = null;
            if (element.getParentNode() != null) {
                parentUri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(element.getParentNode(), prefix3);
            }
            if (parentUri == null || parentUri.length() == 0) {
                this.startPrefixMapping(prefix3, namespaceURI);
            }
        }
        if (this.namespaceDeclarations != null) {
            for (Map.Entry entry : this.namespaceDeclarations.entrySet()) {
                this.addNamespaceDeclaration(element, (String)entry.getKey(), (String)entry.getValue());
            }
            this.namespaceDeclarations = null;
        }
        int numberOfAttributes = atts.getLength();
        int x = 0;
        while (x < numberOfAttributes) {
            String attributeNamespaceURI = atts.getURI(x);
            if (attributeNamespaceURI != null && attributeNamespaceURI.length() == 0) {
                attributeNamespaceURI = null;
            }
            if (attributeNamespaceURI == null && atts.getQName(x).startsWith("xmlns:")) {
                attributeNamespaceURI = "http://www.w3.org/2000/xmlns/";
            }
            String value = atts.getValue(x);
            if (attributeNamespaceURI == null) {
                element.setAttribute(atts.getQName(x), value);
            } else {
                element.setAttributeNS(attributeNamespaceURI, atts.getQName(x), value == null ? "" : value);
            }
            if (value != null) {
                this.processNamespacesForText(value, element);
            }
            ++x;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.nodes.size() == 2) {
            Element endedElement = (Element)this.nodes.get(this.nodes.size() - 1);
            if (this.stringBuffer.length() > 0) {
                Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
                endedElement.appendChild(text);
                this.stringBuffer.reset();
                this.processNamespacesForText(text.getTextContent(), endedElement);
            }
            this.owningRecord.getXMLReader().setContentHandler(this.owningRecord);
            this.owningRecord.endElement(namespaceURI, localName, qName);
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    public void endSelfElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.nodes.size() == 2) {
            Element endedElement = (Element)this.nodes.get(this.nodes.size() - 1);
            if (this.stringBuffer.length() > 0) {
                Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
                endedElement.appendChild(text);
                this.stringBuffer.reset();
            }
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setOwningRecord(UnmarshalRecord record) {
        this.owningRecord = record;
    }

    @Override
    public void appendChildNode(Node parent, Node child) {
        if (parent != this.getDocument()) {
            parent.appendChild(child);
        }
    }

    public Attr buildAttributeNode(String namespaceURI, String localName, String value) {
        try {
            Attr attribute = this.getInitializedDocument().createAttributeNS(namespaceURI, localName);
            attribute.setValue(value);
            return attribute;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public Text buildTextNode(String textValue) {
        try {
            Text text = this.getInitializedDocument().createTextNode(textValue);
            return text;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    private void processNamespacesForText(String textValue, Element parentNode) {
        int colon = textValue.indexOf(58);
        if (colon != -1) {
            String prefix = textValue.substring(0, colon);
            XMLPlatform platform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String uri = platform.resolveNamespacePrefix(parentNode, prefix);
            if (uri == null && (uri = this.owningRecord.resolveNamespacePrefix(prefix)) != null) {
                this.addNamespaceDeclaration(parentNode, prefix, uri);
            }
        }
    }
}

