/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLSubType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AnchoredTypesTestSuite {
    static final String CREATE_PACKAGE_PREFIX = "CREATE PACKAGE ";
    static DDLParser parser = null;
    static final String ANCHORED_TYPES_TEST1_PACKAGE = "ANCHORED_TYPES_TEST1";
    static final String ANCHORED_TYPES_TABLE = "ANCHORED_TYPES_TABLE";
    static final String ANCHORED_TYPES_TABLE_FIELD = "NAME";
    static final String ANCHORED_TYPE1_NAME = "WNAME";
    static final String ANCHORED_TYPE1 = "ANCHORED_TYPES_TABLE.NAME%TYPE";
    static final String CREATE_ANCHORED_TYPES_TEST1_PACKAGE = "CREATE PACKAGE ANCHORED_TYPES_TEST1 AS\nSUBTYPE WNAME IS ANCHORED_TYPES_TABLE.NAME%TYPE;\nEND ANCHORED_TYPES_TEST1;";
    static final String ANCHORED_TYPES_TEST2_PACKAGE = "ANCHORED_TYPES_TEST2";
    static final String ANCHORED_TYPE2_NAME = "WREC";
    static final String ANCHORED_TYPE2 = "ANCHORED_TYPES_TABLE%ROWTYPE";
    static final String CREATE_ANCHORED_TYPES_TEST2_PACKAGE = "CREATE PACKAGE ANCHORED_TYPES_TEST2 AS\nSUBTYPE WNAME IS ANCHORED_TYPES_TABLE.NAME%TYPE;\nSUBTYPE WREC IS ANCHORED_TYPES_TABLE%ROWTYPE;\nTYPE WREC_CURSOR IS REF CURSOR RETURN WREC;\nEND ANCHORED_TYPES_TEST2;";
    static final String ANCHORED_TYPES_TEST3_PACKAGE = "ANCHORED_TYPES_TEST3";
    static final String VAR_NAME = "WREC";
    static final String CREATE_ANCHORED_TYPES_TEST3_PACKAGE = "CREATE PACKAGE ANCHORED_TYPES_TEST3 AS\nWREC ANCHORED_TYPES_TABLE%ROWTYPE;\nSUBTYPE WNAME IS WREC.NAME%TYPE;\nTYPE WREC_CURSOR IS REF CURSOR RETURN WREC%TYPE;\nEND ANCHORED_TYPES_TEST3;";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void anchoredTypesTest1() {
        parser.ReInit(new StringReader(CREATE_ANCHORED_TYPES_TEST1_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"ANCHORED_TYPES_TEST1 package should parse", (boolean)worked);
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST1 package wrong name", (Object)packageType.getPackageName(), (Object)ANCHORED_TYPES_TEST1_PACKAGE);
        Assert.assertNotNull((String)"ANCHORED_TYPES_TEST1 package should have types", packageType.getTypes());
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST1 package should have exactly 1 type", (long)1L, (long)packageType.getTypes().size());
        PLSQLType type = packageType.getTypes().get(0);
        Assert.assertEquals((String)"type has wrong name", (Object)ANCHORED_TYPE1_NAME, (Object)type.getTypeName());
        Assert.assertTrue((String)"WNAME is not SUBTYPE", (boolean)type.isPLSQLSubType());
        PLSQLSubType subType = (PLSQLSubType)type;
        Assert.assertFalse((String)"WNAME is not supposed to have a NOT NULL constraint", (boolean)subType.isNotNull());
        Assert.assertFalse((String)"WNAME is not supposed to have a RANGE constraint", (boolean)subType.hasRange());
        DatabaseType enclosedType = subType.getEnclosedType();
        Assert.assertFalse((String)"WNAME's enclosedType is not supposed to be resolved", (boolean)enclosedType.isResolved());
        Assert.assertEquals((String)"WNAME's enclosedType is incorrect", (Object)ANCHORED_TYPE1, (Object)enclosedType.getTypeName());
    }

    @Test
    public void anchoredTypesTest2() {
        parser.ReInit(new StringReader(CREATE_ANCHORED_TYPES_TEST2_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"ANCHORED_TYPES_TEST2 package should parse", (boolean)worked);
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST2 package wrong name", (Object)packageType.getPackageName(), (Object)ANCHORED_TYPES_TEST2_PACKAGE);
        Assert.assertNotNull((String)"ANCHORED_TYPES_TEST2 package should have types", packageType.getTypes());
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST2 package should have exactly 2 types", (long)2L, (long)packageType.getTypes().size());
        PLSQLType type1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"type has wrong name", (Object)ANCHORED_TYPE1_NAME, (Object)type1.getTypeName());
        Assert.assertTrue((String)"WNAME is not SUBTYPE", (boolean)type1.isPLSQLSubType());
        PLSQLSubType subType = (PLSQLSubType)type1;
        Assert.assertFalse((String)"WNAME is not supposed to have a NOT NULL constraint", (boolean)subType.isNotNull());
        Assert.assertFalse((String)"WNAME is not supposed to have a RANGE constraint", (boolean)subType.hasRange());
        DatabaseType enclosedType = subType.getEnclosedType();
        Assert.assertFalse((String)"WNAME's enclosedType is not supposed to be resolved", (boolean)enclosedType.isResolved());
        Assert.assertEquals((String)"WNAME's enclosedType is incorrect", (Object)ANCHORED_TYPE1, (Object)enclosedType.getTypeName());
        PLSQLType type2 = packageType.getTypes().get(1);
        Assert.assertEquals((String)"type has wrong name", (Object)"WREC", (Object)type2.getTypeName());
        Assert.assertTrue((String)"WREC is not SUBTYPE", (boolean)type2.isPLSQLSubType());
        PLSQLSubType subType2 = (PLSQLSubType)type2;
        Assert.assertFalse((String)"WREC is not supposed to have a NOT NULL constraint", (boolean)subType2.isNotNull());
        Assert.assertFalse((String)"WREC is not supposed to have a RANGE constraint", (boolean)subType2.hasRange());
        DatabaseType enclosedType2 = subType2.getEnclosedType();
        Assert.assertFalse((String)"WREC's enclosedType is not supposed to be resolved", (boolean)enclosedType2.isResolved());
        Assert.assertEquals((String)"WREC's enclosedType is incorrect", (Object)ANCHORED_TYPE2, (Object)enclosedType2.getTypeName());
        PLSQLCursorType cursor = packageType.getCursors().get(0);
        Assert.assertEquals((String)"cursor has wrong name", (Object)"WREC_CURSOR", (Object)cursor.getCursorName());
        Assert.assertFalse((String)"WREC_CURSOR is not supposed to be weakly typed", (boolean)cursor.isWeaklyTyped());
        Assert.assertEquals((String)"WREC_CURSOR returns wrong type", (Object)"WREC", (Object)cursor.getEnclosedType().getTypeName());
        Assert.assertFalse((String)"WREC_CURSOR's return type is not supposed to be resolved", (boolean)cursor.getEnclosedType().isResolved());
    }

    @Test
    public void anchoredTypesTest3() {
        parser.ReInit(new StringReader(CREATE_ANCHORED_TYPES_TEST3_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"ANCHORED_TYPES_TEST3 package should parse", (boolean)worked);
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST3 package wrong name", (Object)packageType.getPackageName(), (Object)ANCHORED_TYPES_TEST3_PACKAGE);
        Assert.assertNotNull((String)"ANCHORED_TYPES_TEST3 package should have variables", packageType.getLocalVariables());
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST3 package should have exactly 1 variables", (long)1L, (long)packageType.getLocalVariables().size());
        FieldType var1 = packageType.getLocalVariables().get(0);
        Assert.assertEquals((String)"WREC wrong name", (Object)"WREC", (Object)var1.getFieldName());
        Assert.assertEquals((String)"WREC wrong datatype", (Object)ANCHORED_TYPE2, (Object)var1.getEnclosedType().getTypeName());
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST3 package should have exactly 1 type", (long)1L, (long)packageType.getTypes().size());
        PLSQLType type1 = packageType.getTypes().get(0);
        Assert.assertEquals((String)"type has wrong name", (Object)ANCHORED_TYPE1_NAME, (Object)type1.getTypeName());
        Assert.assertTrue((String)"WNAME is not SUBTYPE", (boolean)type1.isPLSQLSubType());
        PLSQLSubType subType = (PLSQLSubType)type1;
        Assert.assertFalse((String)"WNAME is not supposed to have a NOT NULL constraint", (boolean)subType.isNotNull());
        Assert.assertFalse((String)"WNAME is not supposed to have a RANGE constraint", (boolean)subType.hasRange());
        DatabaseType enclosedType = subType.getEnclosedType();
        Assert.assertFalse((String)"WNAME's enclosedType is not supposed to be resolved", (boolean)enclosedType.isResolved());
        Assert.assertEquals((String)"WNAME's enclosedType is incorrect", (Object)"WREC.NAME%TYPE", (Object)enclosedType.getTypeName());
        PLSQLCursorType cursor = packageType.getCursors().get(0);
        Assert.assertEquals((String)"cursor has wrong name", (Object)"WREC_CURSOR", (Object)cursor.getCursorName());
        Assert.assertFalse((String)"WREC_CURSOR is not supposed to be weakly typed", (boolean)cursor.isWeaklyTyped());
        Assert.assertEquals((String)"WREC_CURSOR returns wrong type", (Object)"WREC%TYPE", (Object)cursor.getEnclosedType().getTypeName());
        Assert.assertFalse((String)"WREC_CURSOR's return type is not supposed to be resolved", (boolean)cursor.getEnclosedType().isResolved());
    }
}

