/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMapContainerPolicy
extends MWModel
implements MWContainerPolicy {
    private MWMethodHandle keyMethodHandle;
    public static final String KEY_METHOD_PROPERTY = "keyMethod";
    private DefaultingContainerClass containerClass;

    protected MWMapContainerPolicy() {
    }

    public MWMapContainerPolicy(MWMapContainerMapping parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.keyMethodHandle = new MWMethodHandle(this, this.buildKeyMethodScrubber());
        this.containerClass = new DefaultingContainerClass(this);
    }

    public MWMethod getKeyMethod() {
        return this.keyMethodHandle.getMethod();
    }

    public void setKeyMethod(MWMethod newValue) {
        MWMethod oldValue = this.getKeyMethod();
        this.keyMethodHandle.setMethod(newValue);
        this.firePropertyChanged(KEY_METHOD_PROPERTY, oldValue, newValue);
    }

    @Override
    public DefaultingContainerClass getDefaultingContainerClass() {
        return this.containerClass;
    }

    public MWMapContainerMapping getMapContainerMapping() {
        return (MWMapContainerMapping)this.getParent();
    }

    private MWClassAttribute getInstanceVariable() {
        return ((MWMapping)this.getParent()).getInstanceVariable();
    }

    public Iterator candidateKeyMethods() {
        MWDescriptor refDescriptor = this.getMapContainerMapping().getReferenceDescriptor();
        return refDescriptor != null ? refDescriptor.getMWClass().candidateMapContainerPolicyKeyMethods() : NullIterator.instance();
    }

    @Override
    public boolean usesSorting() {
        return false;
    }

    @Override
    public void setUsesSorting(boolean sort) {
    }

    @Override
    public MWClass getComparatorClass() {
        return null;
    }

    @Override
    public void setComparatorClass(MWClass comparatorClass) {
    }

    @Override
    public void referenceDescriptorChanged(MWDescriptor newReferenceDescriptor) {
        if (newReferenceDescriptor == null || this.getKeyMethod() != null && !CollectionTools.contains(this.candidateKeyMethods(), (Object)this.getKeyMethod())) {
            this.setKeyMethod(null);
        }
    }

    @Override
    public MWClass defaultContainerClass() {
        if (this.getMapContainerMapping().usesTransparentIndirection()) {
            return this.defaultIndirectContainerClass();
        }
        MWClassAttribute instanceVariable = this.getInstanceVariable();
        MWClass attributeContainerType = instanceVariable.isValueHolder() ? this.getInstanceVariable().getValueType() : this.getInstanceVariable().getType();
        if (attributeContainerType.isAssignableToMap() && attributeContainerType.isInstantiable()) {
            return attributeContainerType;
        }
        return this.typeFor(HashMap.class);
    }

    private MWClass defaultIndirectContainerClass() {
        return this.typeFor(IndirectMap.class);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.keyMethodHandle);
        children.add(this.containerClass);
    }

    private MWHandle.NodeReferenceScrubber buildKeyMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMapContainerPolicy.this.setKeyMethod(null);
            }

            public String toString() {
                return "MWMapContainerPolicy.buildKeyMethodScrubber()";
            }
        };
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        MWMethod keyMethod = this.getKeyMethod();
        if (keyMethod == null) {
            currentProblems.add(this.buildProblem("0475"));
        } else {
            this.checkKeyMethod(keyMethod, currentProblems);
        }
        this.checkContainerClass(currentProblems);
    }

    private void checkKeyMethod(MWMethod keyMethod, List currentProblems) {
        if (keyMethod.isCandidateMapContainerPolicyKeyMethod()) {
            if (!CollectionTools.contains(this.candidateKeyMethods(), (Object)keyMethod)) {
                currentProblems.add(this.buildProblem("0476"));
            }
        } else {
            currentProblems.add(this.buildProblem("0477"));
        }
    }

    protected void checkContainerClass(List currentProblems) {
        MWClass containerType = this.getDefaultingContainerClass().getContainerClass();
        if (containerType != null && !containerType.mightBeAssignableToMap()) {
            currentProblems.add(this.buildProblem("0472"));
        }
    }

    @Override
    public ContainerPolicy runtimeContainerPolicy() {
        MapContainerPolicy containerPolicy = new MapContainerPolicy(this.getDefaultingContainerClass().getContainerClass().getName());
        String keyMethodName = this.getKeyMethod() != null ? this.getKeyMethod().getName() : null;
        containerPolicy.setKeyName(keyMethodName);
        return containerPolicy;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMapContainerPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        XMLCompositeObjectMapping keyMethodHandleMapping = new XMLCompositeObjectMapping();
        keyMethodHandleMapping.setAttributeName("keyMethodHandle");
        keyMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        keyMethodHandleMapping.setSetMethodName("setKeyMethodHandleForTopLink");
        keyMethodHandleMapping.setGetMethodName("getKeyMethodHandleForTopLink");
        keyMethodHandleMapping.setXPath("key-method-handle");
        descriptor.addMapping((DatabaseMapping)keyMethodHandleMapping);
        XMLCompositeObjectMapping containerClassMapping = new XMLCompositeObjectMapping();
        containerClassMapping.setAttributeName("containerClass");
        containerClassMapping.setReferenceClass(DefaultingContainerClass.class);
        containerClassMapping.setXPath("container-class");
        descriptor.addMapping((DatabaseMapping)containerClassMapping);
        return descriptor;
    }

    private MWMethodHandle getKeyMethodHandleForTopLink() {
        return this.keyMethodHandle.getMethod() == null ? null : this.keyMethodHandle;
    }

    private void setKeyMethodHandleForTopLink(MWMethodHandle keyMethodHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildKeyMethodScrubber();
        this.keyMethodHandle = keyMethodHandle == null ? new MWMethodHandle(this, scrubber) : keyMethodHandle.setScrubber(scrubber);
    }
}

