/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ColumnPairsPanel
extends AbstractPanel {
    private PropertyValueModel referenceHolder;
    private ListValueModel sourceColumnsHolder;
    private ListValueModel targetColumnsHolder;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedColumnPairHolder;
    private CollectionValueModel sortedColumnPairsAdapter;
    private Collection componentsForEnablement;
    private Action removeAction;
    private JTable table;

    public ColumnPairsPanel(WorkbenchContextHolder contextHolder, PropertyValueModel referenceHolder) {
        super(contextHolder);
        this.initialize(referenceHolder);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel referenceHolder) {
        this.referenceHolder = referenceHolder;
        this.componentsForEnablement = new Vector();
        this.sourceColumnsHolder = this.buildSortedColumnsHolder(this.buildSourceTableHolder());
        this.targetColumnsHolder = this.buildSortedColumnsHolder(this.buildTargetTableHolder());
        this.sortedColumnPairsAdapter = this.buildColumnPairsAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedColumnPairHolder = this.buildSelectedColumnPairHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildSortedColumnsHolder(PropertyValueModel tableHolder) {
        return new SortedListValueModelAdapter(this.buildColumnsAdapter(tableHolder));
    }

    private CollectionValueModel buildColumnsAdapter(PropertyValueModel tableHolder) {
        return new CollectionAspectAdapter(tableHolder, "columns"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private PropertyValueModel buildSourceTableHolder() {
        return new PropertyAspectAdapter(this.referenceHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReference)this.subject).getSourceTable();
            }
        };
    }

    private PropertyValueModel buildTargetTableHolder() {
        return new PropertyAspectAdapter(this.referenceHolder, "targetTable"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReference)this.subject).getTargetTable();
            }
        };
    }

    private CollectionValueModel buildColumnPairsAdapter() {
        return new CollectionAspectAdapter(this.referenceHolder, "columnPairs"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWReference)this.subject).columnPairs();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWReference)this.subject).columnPairsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedColumnPairsAdapter, this.buildColumnAdapter());
    }

    protected ColumnAdapter buildColumnAdapter() {
        return new ColumnPairsColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedColumnPairHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedColumnPairsAdapter));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        rowSelectionModel.setSelectionMode(0);
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ColumnPairsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object selection = this.rowSelectionModel.getSelectedValue();
        this.selectedColumnPairHolder.setValue(selection);
        boolean associationSelected = selection != null;
        this.removeAction.setEnabled(associationSelected);
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)buttonPanel, constraints);
        this.table = this.buildTable();
        this.componentsForEnablement.add(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        scrollPane.getViewport().setBackground(this.table.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)scrollPane, constraints);
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        SwingComponentFactory.attachTableEditorCanceler(table, this.referenceHolder);
        table.getTableHeader().setReorderingAllowed(false);
        int rowHeight = 20;
        TableColumn sourceFieldColumn = table.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer sourceFieldRenderer = this.buildSourceColumnComboBoxRenderer();
        sourceFieldColumn.setCellRenderer(sourceFieldRenderer);
        sourceFieldColumn.setCellEditor(new TableCellEditorAdapter(this.buildSourceColumnComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, sourceFieldRenderer.getPreferredHeight());
        TableColumn targetFieldColumn = table.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer targetFieldRenderer = this.buildTargetColumnComboBoxRenderer();
        targetFieldColumn.setCellRenderer(targetFieldRenderer);
        targetFieldColumn.setCellEditor(new TableCellEditorAdapter(this.buildTargetColumnComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, targetFieldRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? "" : ((MWColumn)value).getName();
            }
        };
    }

    private ComboBoxTableCellRenderer buildSourceColumnComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildSourceColumnComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private ComboBoxModel buildSourceColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.sourceColumnsHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ComboBoxTableCellRenderer buildTargetColumnComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildTargetColumnComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private ComboBoxModel buildTargetColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.targetColumnsHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        JButton addButton = this.buildAddButton();
        this.componentsForEnablement.add(addButton);
        buttonPanel.add(addButton);
        this.addAlignRight(addButton);
        JButton removeButton = this.buildRemoveButton();
        this.componentsForEnablement.add(removeButton);
        buttonPanel.add(removeButton);
        this.addAlignRight(removeButton);
        return buttonPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.initializeText("ADD_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("ADD_ASSOCIATION_BUTTON_TEXT");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ColumnPairsPanel.this.addColumnPair();
            }
        };
        action.setEnabled(false);
        this.referenceHolder.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                action.setEnabled(ColumnPairsPanel.this.selectedReference() != null);
            }
        });
        return action;
    }

    private void addColumnPair() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.selectedReference().getSourceTable().columnsSize() == 0 || this.selectedReference().getTargetTable().columnsSize() == 0) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("TABLE_HAS_NO_FIELDS.message"), this.resourceRepository().getString("TABLE_HAS_NO_FIELDS.title"), 2);
            return;
        }
        this.selectedReference().addColumnPair((MWColumn)this.selectedReference().getSourceTable().columns().next(), (MWColumn)this.selectedReference().getTargetTable().columns().next());
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.initializeText("REMOVE_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_ASSOCIATION_BUTTON_TEXT");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ColumnPairsPanel.this.removeColumnPair();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeColumnPair() {
        MWColumnPair association;
        int option;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.title"), 0, 3)) == 0 && (association = this.selectedColumnPair()) != null) {
            this.selectedReference().removeColumnPair(association);
        }
    }

    private MWColumnPair selectedColumnPair() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWColumnPair)this.rowSelectionModel.getSelectedValue();
    }

    private MWReference selectedReference() {
        return (MWReference)this.referenceHolder.getValue();
    }

    public Collection getComponentsForEnablement() {
        return this.componentsForEnablement;
    }

    public static class ColumnPairsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int SOURCE_FIELD_COLUMN = 0;
        public static final int TARGET_FIELD_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"SOURCE_COLUMN_COLUMN_HEADER", "TARGET_COLUMN_COLUMN_HEADER"};

        protected ColumnPairsColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int index) {
            return true;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWColumnPair association = (MWColumnPair)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildSourceColumnAdapter(association), this.buildTargetColumnAdapter(association)};
            return result;
        }

        private PropertyValueModel buildSourceColumnAdapter(MWColumnPair association) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("sourceColumn", (Model)association){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getSourceColumn();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWColumnPair)this.subject).setSourceColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildTargetColumnAdapter(MWColumnPair association) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("targetColumn", (Model)association){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getTargetColumn();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWColumnPair)this.subject).setTargetColumn((MWColumn)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }
    }
}

