/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappings.MappingsBundle;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;

public class Generator {
    private Adapter adapter;
    private StringRepository stringRepository;

    public Generator(Adapter adapter) {
        this.adapter = adapter;
        this.stringRepository = new DefaultStringRepository(MappingsBundle.class);
    }

    protected void execute(String[] args) {
        int status = 0;
        PrintStream log = null;
        if (args.length < 2 || args.length > 3) {
            System.err.println(this.stringRepository.getString("help", this.adapter.getClass().getName()));
            System.exit(1);
        }
        if (args.length == 3) {
            try {
                log = new PrintStream(new FileOutputStream(args[2]));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                log = System.err;
                status = 1;
            }
        } else {
            log = System.err;
        }
        status = this.execute(args[0], args[1], log);
        System.exit(status);
    }

    public int execute(String input, String output, PrintStream log) {
        int status = 0;
        File inputFile = new File(input);
        File outputFile = new File(output);
        try {
            MWProject project = new ProjectIOManager().read(inputFile, Preferences.userNodeForPackage(this.getClass()));
            project.validateBranch();
            if (project.hasBranchProblems()) {
                log.print(this.stringRepository.getString("generatingMight"));
            }
            this.adapter.export(project, outputFile);
        }
        catch (Throwable ex) {
            ex.printStackTrace(log);
            status = 1;
        }
        if (status == 0) {
            System.out.println(this.stringRepository.getString("EOJ"));
        } else {
            System.out.println(this.stringRepository.getString("generationError"));
        }
        return status;
    }

    public int execute(String input, String output) {
        return this.execute(input, output, System.err);
    }

    public static interface Adapter {
        public void export(MWProject var1, File var2);
    }
}

