/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class MappingCanNotBeReadOnlyTest
extends ExceptionTest {
    ClassDescriptor descriptor;
    DirectToFieldMapping mapping;
    boolean orgReadOnly;
    IntegrityChecker orgIntegrityChecker;
    VersionLockingPolicy policy;

    public MappingCanNotBeReadOnlyTest() {
        this.setDescription("This tests Mapping Can Not Be Read Only (TL-ERROR 118)");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.descriptor = this.getSession().getDescriptor(Employee.class);
        this.mapping = (DirectToFieldMapping)this.descriptor.getMappingForAttributeName("firstName");
        this.descriptor.getObjectBuilder().getMappingsByField().remove(this.mapping.getField());
        Vector<DirectToFieldMapping> mappings = new Vector<DirectToFieldMapping>();
        mappings.add(this.mapping);
        this.descriptor.getObjectBuilder().getReadOnlyMappingsByField().put(this.mapping.getField(), mappings);
        this.orgReadOnly = this.mapping.isReadOnly();
        this.mapping.readOnly();
        this.expectedException = DescriptorException.mappingCanNotBeReadOnly((DatabaseMapping)this.mapping);
        this.policy = new VersionLockingPolicy();
        this.policy.storeInObject();
        this.policy.setWriteLockFieldName("EMPLOYEE.F_NAME");
        this.descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.policy);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.descriptor.getObjectBuilder().getMappingsByField().put(this.mapping.getField(), this.mapping);
        this.descriptor.getObjectBuilder().getReadOnlyMappingsByField().remove(this.mapping.getField());
        this.mapping.setIsReadOnly(this.orgReadOnly);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.policy.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

