/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote.suncorba;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.corba.sun.CORBARemoteSessionController;
import org.eclipse.persistence.sessions.remote.corba.sun.CORBARemoteSessionControllerDispatcher;
import org.eclipse.persistence.testing.tests.remote.suncorba._CORBAServerManagerImplBase;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class CORBAServerManagerController
extends _CORBAServerManagerImplBase {
    protected Session session;
    protected String controllerClassName;

    public CORBAServerManagerController(Session session) {
        this.session = session;
    }

    public CORBAServerManagerController(Session session, String controllerClassName) {
        this(session);
        this.controllerClassName = controllerClassName;
    }

    @Override
    public CORBARemoteSessionController createRemoteSessionController() {
        CORBARemoteSessionControllerDispatcher controller = null;
        if (this.controllerClassName == null) {
            controller = new CORBARemoteSessionControllerDispatcher(this.getSession());
        } else {
            try {
                Class<?> cls = Class.forName(this.controllerClassName);
                Class[] parameterTypes = new Class[]{Session.class};
                Constructor<?> constructor = cls.getConstructor(parameterTypes);
                java.lang.Object[] params = new java.lang.Object[]{this.getSession()};
                controller = (CORBARemoteSessionController)constructor.newInstance(params);
            }
            catch (Exception exception) {
                System.out.println("Error instantiating  " + this.controllerClassName + " " + exception.toString());
            }
        }
        return controller;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public static void start(Session session) {
        CORBAServerManagerController.start(session, "CORBAServer", null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameComponent start(Session session, String nameToBind, String controllerClassName, boolean wait) {
        try {
            ORB orb = ORB.init((String[])new String[0], (Properties)new Properties());
            CORBAServerManagerController server = new CORBAServerManagerController(session, controllerClassName);
            orb.connect((Object)server);
            Object objRef = orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent nc = new NameComponent(nameToBind, "");
            NameComponent[] path = new NameComponent[]{nc};
            ncRef.rebind(path, (Object)server);
            java.lang.Object sync = new java.lang.Object();
            if (wait) {
                java.lang.Object object = sync;
                synchronized (object) {
                    sync.wait();
                }
            }
            System.out.println(server + " is ready.");
            return nc;
        }
        catch (Exception exception) {
            System.out.println("CORBA Error");
            exception.printStackTrace();
            return null;
        }
    }
}

