/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;

public class WriteTransformerMetadata
extends ReadTransformerMetadata {
    private ColumnMetadata m_column;

    public WriteTransformerMetadata() {
        super("<write-transformer>");
    }

    public WriteTransformerMetadata(MetadataAnnotation writeTransformer, MetadataAccessor accessor) {
        super(writeTransformer, accessor);
        Object column = writeTransformer.getAttribute("column");
        this.m_column = column != null ? new ColumnMetadata((MetadataAnnotation)column, accessor) : new ColumnMetadata(accessor.getAccessibleObject().getAnnotation("javax.persistence.Column"), accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof WriteTransformerMetadata) {
            WriteTransformerMetadata writeTransformer = (WriteTransformerMetadata)objectToCompare;
            return this.valuesMatch(this.m_column, writeTransformer.getColumn());
        }
        return false;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public boolean hasFieldName() {
        return this.m_column != null && this.m_column.getName() != null && this.m_column.getName().length() > 0;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_column, accessibleObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(TransformationMapping mapping, String annotatedElementName) {
        if (!this.hasFieldName()) throw ValidationException.writeTransformerHasNoColumnName((String)annotatedElementName);
        if (this.getMethod() == null || this.getMethod().equals("")) {
            if (this.getTransformerClass().isVoid()) {
                throw ValidationException.writeTransformerHasNeitherClassNorMethod((String)annotatedElementName, (String)this.m_column.getName());
            }
            if (!this.getTransformerClass().extendsInterface(FieldTransformer.class)) throw ValidationException.writeTransformerClassDoesntImplementFieldTransformer((String)annotatedElementName, (String)this.m_column.getName());
            mapping.addFieldTransformerClassName(this.m_column.getDatabaseField(), this.getTransformerClass().getName());
            return;
        } else {
            if (!this.getTransformerClass().isVoid()) throw ValidationException.writeTransformerHasBothClassAndMethod((String)annotatedElementName, (String)this.m_column.getName());
            mapping.addFieldTransformation(this.m_column.getDatabaseField(), this.getMethod());
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setFieldName(String fieldName) {
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata();
        }
        this.m_column.setName(fieldName);
    }
}

