/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class EnclosingMethodAttribute
extends Attribute {
    private short classIndex;
    private short methodIndex;
    private FieldType methodReturnDescriptor;
    private FieldType[] methodParameterDescriptors;

    EnclosingMethodAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    @Override
    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        this.classIndex = stream.readU2();
        this.methodIndex = stream.readU2();
    }

    @Override
    void displayInfoStringOn(IndentingPrintWriter writer) {
        this.printFullyQualifiedMethodDeclarationOn(writer);
        writer.println();
    }

    public void printFullyQualifiedMethodDeclarationOn(PrintWriter writer) {
        writer.print(this.className());
        writer.print('.');
        if (this.methodIndex == 0) {
            writer.print("<static initialization>");
            return;
        }
        if (this.methodIsConstructor()) {
            writer.print(this.codeConstructorName());
        } else {
            writer.print(this.methodName());
        }
        writer.print('(');
        int len = this.getMethodParameterDescriptors().length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                writer.write(", ");
            }
            this.getMethodParameterDescriptor(i).printDeclarationOn(writer);
        }
        writer.print(')');
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getMethodReturnDescriptor().accept(visitor);
        FieldType[] ptds = this.getMethodParameterDescriptors();
        int len = ptds.length;
        for (int i = 0; i < len; ++i) {
            ptds[i].accept(visitor);
        }
    }

    private String codeConstructorName() {
        String fullName = this.className();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public String fullyQualifiedSignature() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printFullyQualifiedMethodDeclarationOn(pw);
        return sw.toString();
    }

    public String className() {
        return this.constantPool().getClassConstant(this.classIndex).name();
    }

    public String methodName() {
        NameAndTypeConstant mnatc = this.methodNameAndTypeConstant();
        return mnatc == null ? null : mnatc.name();
    }

    public String methodDescriptor() {
        NameAndTypeConstant mnatc = this.methodNameAndTypeConstant();
        return mnatc == null ? null : mnatc.descriptor();
    }

    public NameAndTypeConstant methodNameAndTypeConstant() {
        short index = this.methodIndex;
        return index == 0 ? null : this.constantPool().getNameAndTypeConstant(index);
    }

    public short getClassIndex() {
        return this.classIndex;
    }

    public short getMethodIndex() {
        return this.methodIndex;
    }

    @Override
    void toString(StringBuffer sb) {
        sb.append(this.fullyQualifiedSignature());
    }

    public boolean methodIsConstructor() {
        return this.methodName().equals("<init>");
    }

    public FieldType getMethodReturnDescriptor() {
        if (this.methodReturnDescriptor == null) {
            this.buildTypeDeclarations();
        }
        return this.methodReturnDescriptor;
    }

    public FieldType[] getMethodParameterDescriptors() {
        if (this.methodParameterDescriptors == null) {
            this.buildTypeDeclarations();
        }
        return this.methodParameterDescriptors;
    }

    public FieldType getMethodParameterDescriptor(int index) {
        if (this.methodParameterDescriptors == null) {
            this.buildTypeDeclarations();
        }
        return this.methodParameterDescriptors[index];
    }

    private void buildTypeDeclarations() {
        StringReader reader = new StringReader(this.methodDescriptor());
        try {
            this.methodParameterDescriptors = Method.buildParameterDescriptors(reader);
            this.methodReturnDescriptor = FieldType.createFieldType(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

