/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.MacBook;
import org.eclipse.persistence.testing.models.jpa.inheritance.MacBookPro;
import org.eclipse.persistence.testing.models.jpa.inheritance.MudTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.RockTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireRating;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireRatingComment;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.TireInfoListener;

public class MixedInheritanceJUnitTestCase
extends JUnitTestCase {
    private static int mudTireId;
    private static int rockTireId;

    public MixedInheritanceJUnitTestCase() {
    }

    public MixedInheritanceJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("MixedInheritanceJUnitTestCase");
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testSetup"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewMudTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testCreateNewRockTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testReadNewMudTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testReadNewRockTire"));
        suite.addTest((Test)new MixedInheritanceJUnitTestCase("testAppleComputers"));
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppleComputers() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MacBook macBook1 = new MacBook();
        macBook1.setRam(Integer.valueOf(2));
        MacBook macBook2 = new MacBook();
        macBook2.setRam(Integer.valueOf(4));
        MacBookPro macBookPro1 = new MacBookPro();
        macBookPro1.setRam(Integer.valueOf(4));
        macBookPro1.setColor("Black");
        MacBookPro macBookPro2 = new MacBookPro();
        macBookPro2.setRam(Integer.valueOf(6));
        macBookPro2.setColor("Red");
        MacBookPro macBookPro3 = new MacBookPro();
        macBookPro3.setRam(Integer.valueOf(8));
        macBookPro3.setColor("Green");
        MacBookPro macBookPro4 = new MacBookPro();
        macBookPro4.setRam(Integer.valueOf(8));
        macBookPro4.setColor("Blue");
        try {
            em.persist((Object)macBook1);
            em.persist((Object)macBook2);
            em.persist((Object)macBookPro1);
            em.persist((Object)macBookPro2);
            em.persist((Object)macBookPro3);
            em.persist((Object)macBookPro4);
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting macbooks: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        List macBooks = em.createNamedQuery("findAllMacBooks").getResultList();
        MixedInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac books were returned: " + macBooks.size() + ", expected: 6"), (macBooks.size() == 6 ? 1 : 0) != 0);
        List macBookPros = em.createNamedQuery("findAllMacBookPros").getResultList();
        MixedInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac book pros were returned: " + macBookPros.size() + ", expected: 4"), (macBookPros.size() == 4 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewMudTire() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MudTireInfo mudTire = new MudTireInfo();
        mudTire.setName("Goodyear Mud Tracks");
        mudTire.setCode("MT-674-A4");
        mudTire.setPressure(new Integer(100));
        mudTire.setTreadDepth(3);
        TireRating tireRating = new TireRating();
        tireRating.setRating("Excellent");
        tireRating.setComment(new TireRatingComment("Tire outperformed all others in adverse conditions"));
        mudTire.setTireRating(tireRating);
        try {
            int prePersistCountBefore = TireInfoListener.PRE_PERSIST_COUNT;
            em.persist((Object)mudTire);
            mudTireId = mudTire.getId();
            this.commitTransaction(em);
            int prePersistCountAfter = TireInfoListener.PRE_PERSIST_COUNT;
            int perPersistCountTotal = prePersistCountAfter - prePersistCountBefore;
            MixedInheritanceJUnitTestCase.assertTrue((String)("The pre persist method was called more than once (" + perPersistCountTotal + ")"), (perPersistCountTotal == 1 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting mud tire: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNewRockTire() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        RockTireInfo rockTire = new RockTireInfo();
        rockTire.setName("Goodyear Mud Tracks");
        rockTire.setCode("AE-678");
        rockTire.setPressure(new Integer(100));
        rockTire.setGrip(RockTireInfo.Grip.SUPER);
        try {
            em.persist((Object)rockTire);
            rockTireId = rockTire.getId();
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            MixedInheritanceJUnitTestCase.fail((String)("Error persisting rock tire: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadNewMudTire() {
        MixedInheritanceJUnitTestCase.assertNotNull((String)"The new mud tire info could not be read back.", (Object)this.createEntityManager().find(MudTireInfo.class, (Object)mudTireId));
    }

    public void testReadNewRockTire() {
        MixedInheritanceJUnitTestCase.assertNotNull((String)"The new rock tire info could not be read back.", (Object)this.createEntityManager().find(RockTireInfo.class, (Object)rockTireId));
    }
}

