/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public final class AWTChangeNotifier
implements ChangeNotifier,
Serializable {
    private static ChangeNotifier INSTANCE;
    private static final long serialVersionUID = 1L;

    public static synchronized ChangeNotifier instance() {
        if (INSTANCE == null) {
            INSTANCE = new AWTChangeNotifier();
        }
        return INSTANCE;
    }

    private AWTChangeNotifier() {
    }

    @Override
    public void stateChanged(final StateChangeListener listener, final StateChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.stateChanged(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.stateChanged(event);
                }

                public String toString() {
                    return "stateChanged";
                }
            });
        }
    }

    @Override
    public void propertyChange(final PropertyChangeListener listener, final PropertyChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.propertyChange(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.propertyChange(event);
                }

                public String toString() {
                    return "propertyChange";
                }
            });
        }
    }

    @Override
    public void itemsAdded(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsAdded(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (Collection)";
                }
            });
        }
    }

    @Override
    public void itemsRemoved(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsRemoved(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (Collection)";
                }
            });
        }
    }

    @Override
    public void collectionChanged(final CollectionChangeListener listener, final CollectionChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.collectionChanged(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.collectionChanged(event);
                }

                public String toString() {
                    return "collectionChanged";
                }
            });
        }
    }

    @Override
    public void itemsAdded(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsAdded(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.itemsAdded(event);
                }

                public String toString() {
                    return "itemsAdded (List)";
                }
            });
        }
    }

    @Override
    public void itemsRemoved(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsRemoved(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.itemsRemoved(event);
                }

                public String toString() {
                    return "itemsRemoved (List)";
                }
            });
        }
    }

    @Override
    public void itemsReplaced(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.itemsReplaced(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.itemsReplaced(event);
                }

                public String toString() {
                    return "itemsReplaced (List)";
                }
            });
        }
    }

    @Override
    public void listChanged(final ListChangeListener listener, final ListChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.listChanged(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.listChanged(event);
                }

                public String toString() {
                    return "listChanged";
                }
            });
        }
    }

    @Override
    public void nodeAdded(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.nodeAdded(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.nodeAdded(event);
                }

                public String toString() {
                    return "nodeAdded";
                }
            });
        }
    }

    @Override
    public void nodeRemoved(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.nodeRemoved(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.nodeRemoved(event);
                }

                public String toString() {
                    return "nodeRemoved";
                }
            });
        }
    }

    @Override
    public void treeChanged(final TreeChangeListener listener, final TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            listener.treeChanged(event);
        } else {
            this.invoke(new Runnable(){

                @Override
                public void run() {
                    listener.treeChanged(event);
                }

                public String toString() {
                    return "treeChanged";
                }
            });
        }
    }

    private void invoke(Runnable r) {
        EventQueue.invokeLater(r);
    }

    private Object readResolve() {
        return AWTChangeNotifier.instance();
    }
}

