/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTypeDeclaration
extends MWModel {
    private MWClassHandle typeHandle;
    private volatile int dimensionality;
    private static final String BRACKETS = "[]";

    private MWTypeDeclaration() {
    }

    public MWTypeDeclaration(MWModel parent) {
        super(parent);
    }

    public MWTypeDeclaration(MWModel parent, MWClass type) {
        this(parent, type, 0);
    }

    public MWTypeDeclaration(MWModel parent, MWClass type, int dimensionality) {
        this(parent);
        this.setType(type);
        this.setDimensionality(dimensionality);
    }

    MWTypeDeclaration(MWModel parent, ExternalClassDescription externalClassDescription) {
        this(parent);
        this.refresh(externalClassDescription);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
    }

    public MWClass getType() {
        return this.typeHandle.getType();
    }

    public void setType(MWClass type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.typeHandle.setType(type);
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public void setDimensionality(int dimensionality) {
        if (dimensionality != 0 && !this.allowsDimension()) {
            throw new IllegalArgumentException("The type declaration 'void' cannot have a dimension: " + new Integer(dimensionality));
        }
        this.dimensionality = dimensionality;
    }

    public String typeName() {
        return this.getType().getName();
    }

    public String shortTypeName() {
        return this.getType().shortName();
    }

    boolean matches(MWTypeDeclaration other) {
        return this.dimensionality == other.getDimensionality() && this.getType() == other.getType();
    }

    boolean hasSameSignatureAs(ExternalClassDescription externalClassDescription) {
        return this.dimensionality == externalClassDescription.getArrayDepth() && this.getType() == this.typeNamed(externalClassDescription.getElementTypeName());
    }

    boolean hasSameSignatureAs(MWMethodParameter methodParameter) {
        return this.dimensionality == methodParameter.getDimensionality() && this.getType() == methodParameter.getType();
    }

    boolean isArray() {
        return !this.isScalar();
    }

    boolean isScalar() {
        return this.dimensionality == 0;
    }

    boolean isVoid() {
        return this.dimensionality == 0 && this.getType().isVoid();
    }

    boolean isValueHolder() {
        return this.dimensionality == 0 && this.getType().isValueHolder();
    }

    boolean isTLValueHolder() {
        return this.dimensionality == 0 && "oracle.toplink.indirection.ValueHolderInterface".equals(this.getType().fullName());
    }

    boolean isBooleanPrimitive() {
        return this.dimensionality == 0 && this.getType().isBooleanPrimitive();
    }

    boolean allowsDimension() {
        return !this.getType().isVoid();
    }

    boolean isAssignableFrom(MWClass otherType) {
        return this.isAssignableFrom(otherType, 0);
    }

    boolean mightBeAssignableFrom(MWClass otherType) {
        return this.mightBeAssignableFrom(otherType, 0);
    }

    boolean isAssignableFrom(MWClass otherType, int otherDimensionality) {
        return this.targetIsAssignableFromSource(this.getType(), this.dimensionality, otherType, otherDimensionality);
    }

    boolean mightBeAssignableFrom(MWClass otherType, int otherDimensionality) {
        return this.targetMightBeAssignableFromSource(this.getType(), this.dimensionality, otherType, otherDimensionality);
    }

    boolean isAssignableFrom(MWTypeDeclaration other) {
        return this.isAssignableFrom(other.getType(), other.getDimensionality());
    }

    boolean mightBeAssignableFrom(MWTypeDeclaration other) {
        return this.mightBeAssignableFrom(other.getType(), other.getDimensionality());
    }

    boolean isAssignableTo(MWClass otherType) {
        return this.isAssignableTo(otherType, 0);
    }

    boolean mightBeAssignableTo(MWClass otherType) {
        return this.mightBeAssignableTo(otherType, 0);
    }

    boolean isAssignableTo(MWClass otherType, int otherDimensionality) {
        return this.targetIsAssignableFromSource(otherType, otherDimensionality, this.getType(), this.dimensionality);
    }

    boolean mightBeAssignableTo(MWClass otherType, int otherDimensionality) {
        return this.targetMightBeAssignableFromSource(otherType, otherDimensionality, this.getType(), this.dimensionality);
    }

    boolean isAssignableTo(MWTypeDeclaration other) {
        return this.isAssignableTo(other.getType(), other.getDimensionality());
    }

    boolean mightBeAssignableTo(MWTypeDeclaration other) {
        return this.mightBeAssignableTo(other.getType(), other.getDimensionality());
    }

    private boolean targetIsAssignableFromSource(MWClass targetType, int targetDimensionality, MWClass sourceType, int sourceDimensionality) {
        if (targetDimensionality == sourceDimensionality) {
            return targetType.isAssignableFrom(sourceType);
        }
        return this.targetIsAssignableFromSource2(targetType, targetDimensionality, sourceType, sourceDimensionality);
    }

    private boolean targetIsAssignableFromSource2(MWClass targetType, int targetDimensionality, MWClass sourceType, int sourceDimensionality) {
        if (targetDimensionality > sourceDimensionality) {
            return false;
        }
        return targetType.isObject() || targetType.isCloneable() || targetType.isSerializable();
    }

    private boolean targetMightBeAssignableFromSource(MWClass targetType, int targetDimensionality, MWClass sourceType, int sourceDimensionality) {
        if (targetDimensionality == sourceDimensionality) {
            return targetType.mightBeAssignableFrom(sourceType);
        }
        return this.targetIsAssignableFromSource2(targetType, targetDimensionality, sourceType, sourceDimensionality);
    }

    boolean isAssignableToCollection() {
        return this.dimensionality == 0 && this.getType().isAssignableToCollection();
    }

    boolean mightBeAssignableToCollection() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToCollection();
    }

    boolean isAssignableToList() {
        return this.dimensionality == 0 && this.getType().isAssignableToList();
    }

    boolean mightBeAssignableToList() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToList();
    }

    boolean isAssignableToSet() {
        return this.dimensionality == 0 && this.getType().isAssignableToSet();
    }

    boolean mightBeAssignableToSet() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToSet();
    }

    boolean isAssignableToMap() {
        return this.dimensionality == 0 && this.getType().isAssignableToMap();
    }

    boolean mightBeAssignableToMap() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToMap();
    }

    boolean isAssignableToIndirectContainer() {
        return this.dimensionality == 0 && this.getType().isAssignableToIndirectContainer();
    }

    boolean mightBeAssignableToIndirectContainer() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToIndirectContainer();
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.typeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTypeDeclaration.this.setType(null);
            }

            public String toString() {
                return "MWTypeDeclaration.buildTypeScrubber()";
            }
        };
    }

    void refresh(ExternalClassDescription externalClassDescription) {
        this.setType(this.typeNamed(externalClassDescription.getElementTypeName()));
        this.setDimensionality(externalClassDescription.getArrayDepth());
    }

    @Override
    public String displayString() {
        int dim = this.dimensionality;
        if (dim == 0) {
            return this.typeName();
        }
        String typeName = this.typeName();
        StringBuffer sb = new StringBuffer(typeName.length() + (dim << 1));
        sb.append(typeName);
        int i = dim;
        while (i-- > 0) {
            sb.append(BRACKETS);
        }
        return sb.toString();
    }

    public String displayStringWithPackage() {
        int dim = this.dimensionality;
        if (dim == 0) {
            return this.getType().displayStringWithPackage();
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.shortTypeName());
        int i = dim;
        while (i-- > 0) {
            sb.append(BRACKETS);
        }
        if (this.getType().isReferenceType()) {
            sb.append(" (");
            sb.append(this.getType().packageDisplayName());
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.displayString());
    }

    void printDeclarationOn(StringBuffer sb) {
        sb.append(this.typeName());
        this.printBracketsOn(sb);
    }

    void printShortDeclarationOn(StringBuffer sb) {
        sb.append(this.shortTypeName());
        this.printBracketsOn(sb);
    }

    String declaration() {
        StringBuffer sb = new StringBuffer(200);
        this.printDeclarationOn(sb);
        return sb.toString();
    }

    void printSignatureOn(StringBuffer sb) {
        this.printDeclarationOn(sb);
    }

    void printShortSignatureOn(StringBuffer sb) {
        this.printShortDeclarationOn(sb);
    }

    String defaultReturnValueString() {
        StringBuffer sb = new StringBuffer(200);
        this.printDefaultReturnValueOn(sb);
        return sb.toString();
    }

    void printDefaultReturnValueOn(StringBuffer sb) {
        if (this.isArray()) {
            sb.append("null");
        } else {
            this.getType().printDefaultReturnValueOn(sb);
        }
    }

    private void printBracketsOn(StringBuffer sb) {
        int i = this.dimensionality;
        while (i-- > 0) {
            sb.append(BRACKETS);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTypeDeclaration.class);
        XMLCompositeObjectMapping typeHandleMapping = new XMLCompositeObjectMapping();
        typeHandleMapping.setAttributeName("typeHandle");
        typeHandleMapping.setReferenceClass(MWClassHandle.class);
        typeHandleMapping.setGetMethodName("getTypeHandleForTopLink");
        typeHandleMapping.setSetMethodName("setTypeHandleForTopLink");
        typeHandleMapping.setXPath("type-handle");
        descriptor.addMapping((DatabaseMapping)typeHandleMapping);
        XMLDirectMapping dimMapping = (XMLDirectMapping)descriptor.addDirectMapping("dimensionality", "dimensionality/text()");
        dimMapping.setNullValue((Object)new Integer(0));
        return descriptor;
    }

    private MWClassHandle getTypeHandleForTopLink() {
        return this.typeHandle.getType() == null ? null : this.typeHandle;
    }

    private void setTypeHandleForTopLink(MWClassHandle typeHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTypeScrubber();
        this.typeHandle = typeHandle == null ? new MWClassHandle(this, scrubber) : typeHandle.setScrubber(scrubber);
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWTypeDeclaration.class);
        XMLCompositeObjectMapping typeHandleMapping = new XMLCompositeObjectMapping();
        typeHandleMapping.setAttributeName("typeHandle");
        typeHandleMapping.setReferenceClass(MWClassHandle.class);
        typeHandleMapping.setGetMethodName("getTypeHandleForTopLink");
        typeHandleMapping.setSetMethodName("setTypeHandleForTopLink");
        typeHandleMapping.setXPath("type-handle");
        descriptor.addMapping((DatabaseMapping)typeHandleMapping);
        XMLDirectMapping dimMapping = (XMLDirectMapping)descriptor.addDirectMapping("dimensionality", "dimensionality/text()");
        dimMapping.setNullValue((Object)new Integer(0));
        return descriptor;
    }

    private void legacy50SetTypeNameForTopLink(String typeName) {
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
        if (ClassTools.classNamedIsArray(typeName)) {
            this.dimensionality = ClassTools.arrayDepthForClassNamed(typeName);
            typeName = ClassTools.elementTypeNameForClassNamed(typeName);
        }
        this.typeHandle.legacySetTypeNameForTopLink(typeName);
    }

    private String legacyGetTypeNameForTopLink() {
        return this.typeHandle.legacyGetTypeNameForTopLink();
    }
}

