/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWRelationalDirectMapping
extends MWDirectMapping
implements AggregateRuntimeFieldNameGenerator {
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";
    private AutoGeneratedQueryKey autoGeneratedQueryKey;

    protected MWRelationalDirectMapping() {
    }

    protected MWRelationalDirectMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.autoGeneratedQueryKey = new AutoGeneratedQueryKey(this);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        String newName = this.getName();
        if (this.attributeValueHasChanged(oldName, newName)) {
            this.autoGeneratedQueryKey.nameChanged(oldName, newName);
        }
    }

    @Override
    protected MWTypeConversionConverter buildTypeConversionConverter() {
        return new MWRelationalTypeConversionConverter(this);
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.columnHandle.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged(COLUMN_PROPERTY, old, column);
    }

    @Override
    public MWQueryKey getAutoGeneratedQueryKey() {
        return this.autoGeneratedQueryKey;
    }

    @Override
    public abstract String iconKey();

    @Override
    public void addWrittenFieldsTo(Collection writtenFields) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getColumn() != null) {
            writtenFields.add(this.getColumn());
        }
    }

    @Override
    public String fieldNameForRuntime() {
        return "DIRECT";
    }

    @Override
    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            @Override
            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_DIRECT_MAPPING";
            }

            @Override
            public Object[] getMessageArguments() {
                return new Object[0];
            }
        };
    }

    @Override
    protected Collection buildAggregateFieldNameGenerators() {
        Collection aggregateFieldNameGenerators = super.buildAggregateFieldNameGenerators();
        aggregateFieldNameGenerators.add(this);
        return aggregateFieldNameGenerators;
    }

    @Override
    public void parentDescriptorMorphedToAggregate() {
        super.parentDescriptorMorphedToAggregate();
        this.setColumn(null);
    }

    @Override
    public boolean fieldIsWritten() {
        return true;
    }

    @Override
    public MWDescriptor owningDescriptor() {
        return (MWDescriptor)this.getParent();
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.autoGeneratedQueryKey);
        children.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDirectMapping.this.setColumn(null);
            }

            public String toString() {
                return "MWRelationalDirectMapping.buildColumnScrubber()";
            }
        };
    }

    @Override
    public void initializeFromMWRelationalDirectMapping(MWRelationalDirectMapping mapping) {
        super.initializeFromMWRelationalDirectMapping(mapping);
        this.setColumn(mapping.getColumn());
    }

    @Override
    protected void initializeFromMWConverterMapping(MWConverterMapping converterMapping) {
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkColumn(newProblems);
    }

    private void checkColumn(List newProblems) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        if (this.getColumn() == null) {
            newProblems.add(this.buildProblem("0420"));
        } else if (!CollectionTools.contains(((MWTableDescriptor)this.getParentDescriptor()).allAssociatedColumns(), (Object)this.getColumn())) {
            newProblems.add(this.buildProblem("0421"));
        }
    }

    @Override
    public void addColumnlessDirectMappingTo(Collection columnlessDirectMappings) {
        if (this.getColumn() == null) {
            columnlessDirectMappings.add(this);
        }
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        DirectToFieldMapping mapping = (DirectToFieldMapping)super.runtimeMapping();
        if (this.parentDescriptorIsAggregate()) {
            mapping.setFieldName(this.getName() + "->" + this.fieldNameForRuntime());
        } else if (this.getColumn() != null) {
            mapping.setFieldName(this.getColumn().qualifiedName());
        } else {
            mapping.setFieldName("");
        }
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalDirectMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWDirectMapping.class);
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        return descriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private static final class AutoGeneratedQueryKey
    extends MWModel
    implements MWQueryKey {
        AutoGeneratedQueryKey(MWRelationalDirectMapping parent) {
            super(parent);
        }

        private MWRelationalDirectMapping getMapping() {
            return (MWRelationalDirectMapping)this.getParent();
        }

        @Override
        public MWColumn getColumn() {
            return this.getMapping().getColumn();
        }

        @Override
        public boolean isAutoGenerated() {
            return true;
        }

        @Override
        public MWRelationalClassDescriptor getDescriptor() {
            return (MWRelationalClassDescriptor)this.getMapping().getParentDescriptor();
        }

        @Override
        public String getName() {
            return this.getMapping().getName();
        }

        void nameChanged(String oldName, String newName) {
            this.firePropertyChanged("name", oldName, newName);
        }

        @Override
        public String displayString() {
            return this.getName();
        }

        @Override
        public void toString(StringBuffer sb) {
            sb.append("field=");
            if (this.getColumn() == null) {
                sb.append("null");
            } else {
                this.getColumn().toString(sb);
            }
        }
    }
}

