/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

public class PropertyValueModelDisplayableAdapter
extends AbstractModel
implements Displayable {
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener valueChangeListener;
    private DisplayableAdapter adapter;

    public PropertyValueModelDisplayableAdapter(PropertyValueModel valueHolder) {
        this(valueHolder, DisplayableAdapter.DEFAULT_INSTANCE);
    }

    public PropertyValueModelDisplayableAdapter(PropertyValueModel valueHolder, DisplayableAdapter adapter) {
        this.valueHolder = valueHolder;
        this.adapter = adapter;
    }

    protected void initialize() {
        super.initialize();
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PropertyValueModelDisplayableAdapter.this.valueChanged(e);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoRelevantListeners()) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyIsRelevant(propertyName) && this.hasNoRelevantListeners()) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoRelevantListeners()) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (this.propertyIsRelevant(propertyName) && this.hasNoRelevantListeners()) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    protected boolean propertyIsRelevant(String propertyName) {
        return propertyName == "displayString" || propertyName == "icon";
    }

    protected boolean hasNoRelevantListeners() {
        return this.hasNoPropertyChangeListeners("displayString") && this.hasNoPropertyChangeListeners("icon");
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    @Override
    public String displayString() {
        return this.displayString(this.valueHolder.getValue());
    }

    @Override
    public Icon icon() {
        return this.icon(this.valueHolder.getValue());
    }

    protected void valueChanged(PropertyChangeEvent e) {
        this.firePropertyChanged("displayString", this.displayString(e.getOldValue()), this.displayString(e.getNewValue()));
        this.firePropertyChanged("icon", this.icon(e.getOldValue()), this.icon(e.getNewValue()));
    }

    protected String displayString(Object object) {
        return this.adapter.displayString(object);
    }

    public Icon icon(Object object) {
        return this.adapter.icon(object);
    }
}

