/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionProjectlPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.ProjectTypeEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

final class SessionProjectPane
extends AbstractSessionProjectlPane {
    SessionProjectPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    private ActionListener buildEditAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionProjectPane.this.edit();
            }
        };
    }

    @Override
    protected JButton buildEditButton() {
        JButton button = this.buildButton("SESSION_PROJECT_EDIT_BUTTON");
        button.addActionListener(this.buildEditAction());
        return button;
    }

    @Override
    protected PropertyValueModel buildPrimaryProjectNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "primaryProject"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                return session.getPrimaryProjectName();
            }
        };
    }

    @Override
    protected JTextField buildPrimaryProjectTextField(Document document) {
        JTextField textField = super.buildPrimaryProjectTextField(document);
        textField.setEditable(false);
        return textField;
    }

    private void edit() {
        DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject();
        ProjectType projectType = new ProjectType(session);
        ProjectTypeEditDialog dialog = new ProjectTypeEditDialog(this.getWorkbenchContext(), this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_EDIT"), session, projectType, "dialog.session.projectType");
        dialog.setVisible(true);
    }

    private static class ProjectType
    extends AbstractModel
    implements ProjectTypeEditDialog.ProjectTypeUpdater {
        private DatabaseSessionAdapter databaseSession;
        private String projectName;
        private boolean projectTypeXml;
        public static final String PROJECT_CLASS_PROPERTY = "ProjectClass";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";
        public static final String PROJECT_XML_PROPERTY = "ProjectXml";

        public ProjectType(DatabaseSessionAdapter databaseSession) {
            this.initialize(databaseSession);
        }

        @Override
        public void apply(boolean projectTypeXml, String projectName) {
            if (projectTypeXml) {
                this.databaseSession.addPrimaryProjectXmlNamed(projectName);
            } else {
                this.databaseSession.addPrimaryProjectClassNamed(projectName);
            }
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        private void initialize(DatabaseSessionAdapter databaseSession) {
            this.databaseSession = databaseSession;
            this.projectTypeXml = databaseSession.isPrimaryProjectXml();
            this.projectName = databaseSession.getPrimaryProjectName();
        }

        @Override
        public boolean isProjectXml() {
            return this.projectTypeXml;
        }
    }
}

