/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ExtractionMethodListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class ClassExtractionMethodPanel
extends AbstractSubjectPanel
implements RootListener,
ExtractionMethodListener {
    private boolean isRoot;
    private boolean isExtractionMethod;
    private ListChooser classExtractionMethodListChooser;

    ClassExtractionMethodPanel(ApplicationContext context, PropertyValueModel classExtractionMethodIndicatorPolicy) {
        super((ValueModel)classExtractionMethodIndicatorPolicy, context);
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.classExtractionMethodListChooser = this.buildClassExtractionMethodChooser();
        this.classExtractionMethodListChooser.putClientProperty("labeledBy", new JLabel(" "));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.classExtractionMethodListChooser, constraints);
        new ComponentEnabler(this.buildUseClassExtractionMethodHolder(), Collections.singleton(this.classExtractionMethodListChooser));
    }

    private ValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)((MWClassIndicatorPolicy)this.subject).getParent()).getOwningDescriptor().getMWClass();
            }
        };
    }

    private ListChooser buildClassExtractionMethodChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildExtendedClassExtractionMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildPostLoadMethodListDialogBuilder());
        listChooser.setRenderer(DescriptorComponentFactory.buildMethodRenderer(this.resourceRepository()));
        return listChooser;
    }

    private CachingComboBoxModel buildExtendedClassExtractionMethodComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildClassExtractionMethodComboBoxModel());
    }

    private CachingComboBoxModel buildClassExtractionMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildClassExtractionMethodChooserPropertyAdapter(), this.buildMWClassHolder()){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return ClassExtractionMethodPanel.this.orderedClassExtractionMethodChoices((MWClass)subject);
            }
        };
    }

    ListIterator orderedClassExtractionMethodChoices(MWClass mwClass) {
        return CollectionTools.sort((Iterator)mwClass.candidateClassExtractionMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildPostLoadMethodListDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("CLASS_EXTRACTION_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("CLASS_EXTRACTION_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(DescriptorComponentFactory.buildMethodStringConverter());
        return builder;
    }

    private PropertyValueModel buildClassExtractionMethodChooserPropertyAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "classExtractionMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassIndicatorExtractionMethodPolicy)this.subject).getClassExtractionMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassIndicatorExtractionMethodPolicy)this.subject).setClassExtractionMethod((MWMethod)value);
            }
        };
    }

    private ValueModel buildUseClassExtractionMethodHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            @Override
            protected Object buildValue() {
                return this.subject == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    @Override
    public void updateRootStatus(boolean newValue) {
        this.isRoot = newValue;
        this.updateEnablementStatus();
    }

    @Override
    public void updateExtractionMethodStatus(boolean newValue) {
        this.isExtractionMethod = newValue;
        this.updateEnablementStatus();
    }

    protected void updateEnablementStatus() {
        this.classExtractionMethodListChooser.setEnabled(this.isRoot() && this.isExtractionMethod());
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isExtractionMethod() {
        return this.isExtractionMethod;
    }
}

