/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class DatabasePlatformChooserDialog
extends AbstractDialog {
    JList list;
    private PropertyValueModel selectionHolder;

    DatabasePlatformChooserDialog(WorkbenchContext context, PropertyValueModel selectionHolder) {
        super(context, context.getApplicationContext().getResourceRepository().getString("DATABASE_PLATFORMS_DIALOG.title"));
        this.selectionHolder = selectionHolder;
    }

    private DoubleClickMouseListener buildDoubleClickMouseListener() {
        return new DoubleClickMouseListener(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                DatabasePlatformChooserDialog.this.clickOK();
            }
        };
    }

    private ListSelectionListener buildListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList list = (JList)e.getSource();
                    DatabasePlatformChooserDialog.this.getOKAction().setEnabled(list.getSelectedValue() != null);
                }
            }
        };
    }

    @Override
    protected Component buildMainPanel() {
        this.list = PlatformComponentFactory.buildPlatformList(this.selectionHolder);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this.buildListSelectionListener());
        SwingComponentFactory.addDoubleClickMouseListener(this.list, this.buildDoubleClickMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.getViewport().setPreferredSize(this.list.getPreferredSize());
        return scrollPane;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.databasePlatform";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.list;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }
}

