/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingMarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMappingMarshalNodeValue
extends NodeValue
implements ContainerValue {
    private XMLChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<XMLField, NodeValue> fieldToNodeValues;
    private NodeValue choiceElementNodeValue;
    private XMLField xmlField;
    private boolean isMixedNodeValue;
    private int index = -1;

    public XMLChoiceCollectionMappingMarshalNodeValue(XMLChoiceCollectionMapping mapping, XMLField xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.isMixedNodeValue) {
            return xPathFragment.nameIsText();
        }
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<XMLField, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
    }

    private void initializeNodeValue() {
        XMLCollectionReferenceMapping refMapping;
        XMLMapping xmlMapping = this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof XMLBinaryDataCollectionMapping ? new XMLBinaryDataCollectionMappingNodeValue((XMLBinaryDataCollectionMapping)xmlMapping) : (xmlMapping instanceof XMLCompositeDirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((XMLCompositeDirectCollectionMapping)xmlMapping) : (xmlMapping instanceof XMLCompositeCollectionMapping ? new XMLCompositeCollectionMappingNodeValue((XMLCompositeCollectionMapping)xmlMapping) : ((refMapping = (XMLCollectionReferenceMapping)xmlMapping).usesSingleNode() || refMapping.getFields().size() == 1 ? new XMLCollectionReferenceMappingNodeValue(refMapping, this.xmlField) : new XMLCollectionReferenceMappingMarshalNodeValue((XMLCollectionReferenceMapping)xmlMapping))));
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment;
        Object iterator;
        if (this.xmlChoiceCollectionMapping.isReadOnly()) {
            return false;
        }
        Object value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
        if (value == null) {
            AbstractNullPolicy wrapperNP = this.xmlChoiceCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL)) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.hasNext(iterator = cp.iteratorFor(value))) {
            if (xPathFragment != null) {
                groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            }
        } else if (this.xmlChoiceCollectionMapping.getWrapperNullPolicy() != null) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return false;
        }
        while (cp.hasNext(iterator)) {
            Object nextValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Converter converter = this.xmlChoiceCollectionMapping.getConverter();
        if (null != converter) {
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller()) : converter.convertObjectValueToDataValue(value, session);
        }
        NodeValue associatedNodeValue = null;
        XMLField associatedField = null;
        Object fieldValue = value;
        if (value == null) {
            Iterator<Map.Entry<XMLField, NodeValue>> iter = this.fieldToNodeValues.entrySet().iterator();
            while (iter.hasNext() && associatedNodeValue == null) {
                Map.Entry<XMLField, NodeValue> nextEntry = iter.next();
                XMLChoiceCollectionMappingUnmarshalNodeValue unmarshalNodeValue = (XMLChoiceCollectionMappingUnmarshalNodeValue)nextEntry.getValue();
                NodeValue nextNodeValue = unmarshalNodeValue.getChoiceElementMarshalNodeValue();
                if (!(nextNodeValue instanceof MappingNodeValue)) continue;
                DatabaseMapping nextMapping = ((MappingNodeValue)nextNodeValue).getMapping();
                if (nextMapping.isAbstractCompositeCollectionMapping()) {
                    if (!((XMLCompositeCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()) continue;
                    associatedNodeValue = unmarshalNodeValue;
                    associatedField = nextEntry.getKey();
                    continue;
                }
                if (nextMapping.isAbstractCompositeDirectCollectionMapping()) {
                    if (!((XMLCompositeDirectCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()) continue;
                    associatedNodeValue = unmarshalNodeValue;
                    associatedField = nextEntry.getKey();
                    continue;
                }
                if (!(nextMapping instanceof XMLBinaryDataCollectionMapping) || !((XMLBinaryDataCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()) continue;
                associatedNodeValue = unmarshalNodeValue;
                associatedField = nextEntry.getKey();
            }
            if (associatedNodeValue == null) {
                return false;
            }
        } else {
            List<XMLField> sourceFields;
            if (value instanceof XMLRoot) {
                XMLRoot rootValue = (XMLRoot)value;
                String localName = rootValue.getLocalName();
                String namespaceUri = rootValue.getNamespaceURI();
                fieldValue = rootValue.getObject();
                associatedField = this.getFieldForName(localName, namespaceUri);
                if (associatedField == null) {
                    associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(fieldValue.getClass());
                }
            } else {
                if (value.getClass() == ClassConstants.STRING && this.xmlChoiceCollectionMapping.isMixedContent()) {
                    this.marshalMixedContent(marshalRecord, (String)value);
                    return true;
                }
                associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(value.getClass());
            }
            if (associatedField == null && (sourceFields = this.xmlChoiceCollectionMapping.getClassToSourceFieldsMappings().get(value.getClass())) != null) {
                associatedField = sourceFields.get(0);
            }
            if (associatedField != null) {
                associatedNodeValue = this.fieldToNodeValues.get(associatedField);
            }
        }
        if (associatedNodeValue != null) {
            XPathFragment frag = associatedField.getXPathFragment();
            NodeValue unwrappedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
            while (frag != null) {
                ContainerValue nestedNodeValue;
                if (associatedNodeValue.isOwningNode(frag)) {
                    nestedNodeValue = (ContainerValue)((Object)unwrappedNodeValue);
                    nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, fieldValue, session, namespaceResolver, marshalContext);
                    break;
                }
                if ((frag = frag.getNextFragment()) != null) continue;
                nestedNodeValue = (ContainerValue)((Object)associatedNodeValue);
                nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, fieldValue, session, namespaceResolver, marshalContext);
            }
        }
        return true;
    }

    private void marshalMixedContent(MarshalRecord record, String value) {
        record.characters(value);
    }

    private XMLField getFieldForName(String localName, String namespaceUri) {
        for (XMLField nextField : this.fieldToNodeValues.keySet()) {
            for (XPathFragment fragment = nextField.getXPathFragment(); fragment != null && !fragment.nameIsText(); fragment = fragment.getNextFragment()) {
                if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(localName)) continue;
                String fragUri = fragment.getNamespaceURI();
                if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                return nextField;
            }
        }
        return null;
    }

    public Collection<NodeValue> getAllNodeValues() {
        return this.fieldToNodeValues.values();
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public XMLChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIsMixedNodeValue(boolean b) {
        this.isMixedNodeValue = b;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.isMixedNodeValue;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

