/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionMemberDeclaration
extends AbstractExpression {
    private AbstractExpression collectionValuedPathExpression;
    private boolean hasAs;
    private boolean hasLeftParenthesis;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterIn;
    private boolean hasSpaceAfterRightParenthesis;
    private AbstractExpression identificationVariable;

    CollectionMemberDeclaration(AbstractExpression parent) {
        super(parent, "IN");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getCollectionValuedPathExpression().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getCollectionValuedPathExpression());
        children.add(this.getIdentificationVariable());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("IN"));
        if (this.hasSpaceAfterIn) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        }
        if (this.collectionValuedPathExpression != null) {
            children.add(this.collectionValuedPathExpression);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
        if (this.hasSpaceAfterRightParenthesis) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    public Expression getCollectionValuedPathExpression() {
        if (this.collectionValuedPathExpression == null) {
            this.collectionValuedPathExpression = this.buildNullExpression();
        }
        return this.collectionValuedPathExpression;
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return CollectionMemberDeclaration.queryBNF("collection_member_declaration");
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasCollectionValuedPathExpression() {
        return this.collectionValuedPathExpression != null && !this.collectionValuedPathExpression.isNull();
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterIn() {
        return this.hasSpaceAfterIn;
    }

    public boolean hasSpaceAfterRightParenthesis() {
        return this.hasSpaceAfterRightParenthesis;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("IN");
        int count = wordParser.skipLeadingWhitespace();
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        } else {
            this.hasSpaceAfterIn = count > 0;
            count = 0;
        }
        this.collectionValuedPathExpression = this.parse(wordParser, (JPQLQueryBNF)CollectionMemberDeclaration.queryBNF("collection_valued_path_expression"), tolerant);
        if (this.hasCollectionValuedPathExpression()) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasRightParenthesis = wordParser.startsWith(')');
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
            this.hasSpaceAfterRightParenthesis = count > 0;
        } else {
            this.hasSpaceAfterRightParenthesis = count > 0;
        }
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            wordParser.moveForward("AS");
            this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        this.identificationVariable = this.parse(wordParser, (JPQLQueryBNF)CollectionMemberDeclaration.queryBNF("identification_variable"), tolerant);
        if (!this.hasLeftParenthesis && this.hasRightParenthesis && !this.hasAs && !this.hasIdentificationVariable()) {
            this.hasRightParenthesis = false;
            this.hasSpaceAfterRightParenthesis = false;
            wordParser.moveBackward(count + 1);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIn) {
            writer.append(' ');
        }
        if (this.collectionValuedPathExpression != null) {
            this.collectionValuedPathExpression.toParsedText(writer, includeVirtual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
        if (this.hasSpaceAfterRightParenthesis) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append("AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null) {
            this.identificationVariable.toParsedText(writer, includeVirtual);
        }
    }

    String toParsedTextUntilAs() {
        StringBuilder writer = new StringBuilder();
        writer.append(this.getText());
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIn) {
            writer.append(' ');
        }
        if (this.collectionValuedPathExpression != null) {
            this.collectionValuedPathExpression.toParsedText(writer, false);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
        if (this.hasSpaceAfterRightParenthesis) {
            writer.append(' ');
        }
        return writer.toString();
    }
}

