/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BetweenExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasAnd;
    private boolean hasNot;
    private boolean hasSpaceAfterAnd;
    private boolean hasSpaceAfterBetween;
    private boolean hasSpaceAfterLowerBound;
    private AbstractExpression lowerBoundExpression;
    private AbstractExpression upperBoundExpression;

    BetweenExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent, "BETWEEN");
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
        this.getLowerBoundExpression().accept(visitor);
        this.getUpperBoundExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
        children.add(this.getLowerBoundExpression());
        children.add(this.getUpperBoundExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression("NOT"));
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("BETWEEN"));
        if (this.hasSpaceAfterBetween) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.lowerBoundExpression != null) {
            children.add(this.lowerBoundExpression);
        }
        if (this.hasSpaceAfterLowerBound) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAnd) {
            children.add(this.buildStringExpression("AND"));
        }
        if (this.hasSpaceAfterAnd) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.upperBoundExpression != null) {
            children.add(this.upperBoundExpression);
        }
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.hasNot ? "NOT BETWEEN" : "BETWEEN";
    }

    public Expression getLowerBoundExpression() {
        if (this.lowerBoundExpression == null) {
            this.lowerBoundExpression = this.buildNullExpression();
        }
        return this.lowerBoundExpression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return BetweenExpression.queryBNF("between_expression");
    }

    public Expression getUpperBoundExpression() {
        if (this.upperBoundExpression == null) {
            this.upperBoundExpression = this.buildNullExpression();
        }
        return this.upperBoundExpression;
    }

    public boolean hasAnd() {
        return this.hasAnd;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasLowerBoundExpression() {
        return this.lowerBoundExpression != null && !this.lowerBoundExpression.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasSpaceAfterAnd() {
        return this.hasSpaceAfterAnd;
    }

    public boolean hasSpaceAfterBetween() {
        return this.hasSpaceAfterBetween;
    }

    public boolean hasSpaceAfterLowerBound() {
        return this.hasSpaceAfterLowerBound;
    }

    public boolean hasUpperBoundExpression() {
        return this.upperBoundExpression != null && !this.upperBoundExpression.isNull();
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || word.equalsIgnoreCase("AND") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.hasNot = wordParser.startsWithIgnoreCase('N');
        if (this.hasNot) {
            wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        wordParser.moveForward("BETWEEN");
        this.hasSpaceAfterBetween = wordParser.skipLeadingWhitespace() > 0;
        this.lowerBoundExpression = this.parse(wordParser, (JPQLQueryBNF)BetweenExpression.queryBNF("internal_between_expression"), tolerant);
        if (this.hasLowerBoundExpression()) {
            this.hasSpaceAfterLowerBound = wordParser.skipLeadingWhitespace() > 0;
        }
        this.hasAnd = wordParser.startsWithIdentifier("AND");
        if (this.hasAnd) {
            wordParser.moveForward("AND");
            this.hasSpaceAfterAnd = wordParser.skipLeadingWhitespace() > 0;
        }
        this.upperBoundExpression = this.parse(wordParser, (JPQLQueryBNF)BetweenExpression.queryBNF("internal_between_expression"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, includeVirtual);
        }
        if (this.hasExpression()) {
            writer.append(' ');
        }
        if (this.hasNot) {
            writer.append("NOT");
            writer.append(' ');
        }
        writer.append("BETWEEN");
        if (this.hasSpaceAfterBetween) {
            writer.append(' ');
        }
        if (this.lowerBoundExpression != null) {
            this.lowerBoundExpression.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterLowerBound) {
            writer.append(' ');
        }
        if (this.hasAnd) {
            writer.append("AND");
        }
        if (this.hasSpaceAfterAnd) {
            writer.append(' ');
        }
        if (this.upperBoundExpression != null) {
            this.upperBoundExpression.toParsedText(writer, includeVirtual);
        }
    }
}

