/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;

public final class LiteralVisitor
extends AnonymousExpressionVisitor {
    public String literal;
    private LiteralType type;

    public LiteralVisitor() {
    }

    LiteralVisitor(LiteralType type) {
        this.setType(type);
    }

    public void setType(LiteralType type) {
        this.type = type;
        this.literal = "";
    }

    public void visit(AbstractSchemaName expression) {
        if (this.type == LiteralType.ABSTRACT_SCHEMA_NAME) {
            this.literal = expression.getText();
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(EntityTypeLiteral expression) {
        if (this.type == LiteralType.ENTITY_TYPE) {
            this.literal = expression.getEntityTypeName();
        }
    }

    public void visit(IdentificationVariable expression) {
        if (this.type == LiteralType.IDENTIFICATION_VARIABLE || this.type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE) {
            this.literal = expression.getText();
        }
    }

    public void visit(InputParameter expression) {
        if (this.type == LiteralType.INPUT_PARAMETER) {
            this.literal = expression.getParameter();
        }
    }

    public void visit(Join expression) {
        if (this.type == LiteralType.IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        } else {
            expression.getJoinAssociationPath().accept(this);
        }
    }

    public void visit(JoinFetch expression) {
        expression.getJoinAssociationPath().accept(this);
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(StringLiteral expression) {
        if (this.type == LiteralType.STRING_LITERAL) {
            this.literal = expression.getText();
        }
    }

    private void visitAbstractPathExpression(AbstractPathExpression expression) {
        if (this.type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE) {
            expression.getIdentificationVariable().accept(this);
        } else if (this.type == LiteralType.PATH_EXPRESSION_ALL_PATH) {
            this.literal = expression.toParsedText();
        } else if (this.type == LiteralType.PATH_EXPRESSION_LAST_PATH) {
            this.literal = expression.getPath(expression.pathSize() - 1);
        }
    }
}

