/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public abstract class RelationalColumnMetadata
extends MetadataColumn {
    private String m_referencedColumnName;

    public RelationalColumnMetadata(MetadataAnnotation relationalColumn, MetadataAccessor accessor) {
        super(relationalColumn, accessor);
        if (relationalColumn != null) {
            this.m_referencedColumnName = (String)relationalColumn.getAttribute("referencedColumnName");
        }
    }

    protected RelationalColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationalColumnMetadata) {
            RelationalColumnMetadata relationalColumn = (RelationalColumnMetadata)objectToCompare;
            return this.valuesMatch(this.m_referencedColumnName, relationalColumn.getReferencedColumnName());
        }
        return false;
    }

    protected DatabaseField getForeignKeyField() {
        return super.getDatabaseField();
    }

    public DatabaseField getForeignKeyField(DatabaseField primaryKeyField) {
        DatabaseField fkField = this.getForeignKeyField();
        if (primaryKeyField != null) {
            fkField.setLength(primaryKeyField.getLength());
            fkField.setPrecision(primaryKeyField.getPrecision());
            fkField.setScale(primaryKeyField.getScale());
        }
        return fkField;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.getName() == null || this.getName().equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }
}

