/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ToggleButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.filters.BidiFilter;

public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    public RadioButtonModelAdapter(PropertyValueModel valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(PropertyValueModel valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static PropertyValueModel buildBooleanHolder(PropertyValueModel valueHolder, Object buttonValue) {
        FilteringPropertyValueModel filteringPVM = new FilteringPropertyValueModel(valueHolder, new RadioButtonFilter(buttonValue));
        return new TransformationPropertyValueModel(filteringPVM, new RadioButtonTransformer(buttonValue));
    }

    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    public static class RadioButtonTransformer
    implements BidiTransformer {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        public Object transform(Object value) {
            return value == null ? null : Boolean.valueOf(value == this.buttonValue);
        }

        public Object reverseTransform(Object value) {
            return (Boolean)value != false ? this.buttonValue : null;
        }
    }

    public static class RadioButtonFilter
    implements BidiFilter {
        private Object buttonValue;

        public RadioButtonFilter(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        public boolean accept(Object value) {
            return true;
        }

        public boolean reverseAccept(Object value) {
            return value == this.buttonValue;
        }
    }
}

