/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyIterator;

public class ListCollectionValueModelAdapter
extends AbstractModel
implements CollectionValueModel {
    protected ListValueModel listHolder;
    protected ListChangeListener listChangeListener;
    protected ArrayList collection;

    public ListCollectionValueModelAdapter(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
    }

    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
        this.collection = new ArrayList();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListCollectionValueModelAdapter.this.listChanged(e);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public Object getValue() {
        return new ReadOnlyIterator((Collection)this.collection);
    }

    public void addItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection items) {
        throw new UnsupportedOperationException();
    }

    public void removeItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection items) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.collection.size();
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.collection.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.collection.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildCollection() {
        Iterator stream = (Iterator)this.listHolder.getValue();
        if (stream.hasNext()) {
            this.collection.ensureCapacity(this.listHolder.size());
            while (stream.hasNext()) {
                this.collection.add(stream.next());
            }
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
        this.buildCollection();
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
        this.collection.clear();
    }

    protected void addInternalItems(Iterator items) {
        Collection addedItems = CollectionTools.collection((Iterator)items);
        this.collection.addAll(addedItems);
        this.fireItemsAdded("value", addedItems);
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.addInternalItems(e.items());
    }

    protected void removeInternalItems(Iterator items) {
        while (items.hasNext()) {
            Object removedItem = items.next();
            int index = this.lastIdentityIndexOf(removedItem);
            this.collection.remove(index);
            this.fireItemRemoved("value", removedItem);
        }
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.removeInternalItems(e.items());
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.removeInternalItems(e.replacedItems());
        this.addInternalItems(e.items());
    }

    protected void listChanged(ListChangeEvent e) {
        if (!this.collection.isEmpty()) {
            ArrayList removedItems = this.collection;
            this.collection = new ArrayList();
            this.fireItemsRemoved("value", removedItems);
        }
        this.buildCollection();
        if (!this.collection.isEmpty()) {
            this.fireItemsAdded("value", this.collection);
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.listHolder);
    }
}

