/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GridLayout;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

abstract class AbstractSessionMultipleProjectsPane
extends AbstractSubjectPanel {
    private ObjectListSelectionModel selectionModel;

    AbstractSessionMultipleProjectsPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    protected abstract void addProject(ObjectListSelectionModel var1);

    private ActionListener buildAddAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractSessionMultipleProjectsPane.this.addProject(AbstractSessionMultipleProjectsPane.this.selectionModel);
            }
        };
    }

    private CollectionValueModel buildAddionalProjectsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "additionalProjects"){

            protected Iterator getValueFromSubject() {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                return session.additionalProjects();
            }
        };
    }

    private ListModel buildAddionalProjectsListAdapter() {
        return new ListModelAdapter(new SortedListValueModelAdapter(this.buildAddionalProjectsCollectionHolder()));
    }

    private ListCellRenderer buildAddiontalProjectsCellRenderer() {
        return new AdaptableListCellRenderer(new CellRendererAdapter());
    }

    private ActionListener buildRemoveAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues = AbstractSessionMultipleProjectsPane.this.selectionModel.getSelectedValues();
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)AbstractSessionMultipleProjectsPane.this.subject();
                for (int index = 0; index < selectedValues.length; ++index) {
                    session.removeProject((ProjectAdapter)((Object)selectedValues[index]));
                }
            }
        };
    }

    private void buildRemoveButtonEnabler(final JButton removeButton) {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                removeButton.setEnabled(AbstractSessionMultipleProjectsPane.this.selectionModel.getSelectedValues().length > 0);
            }
        });
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel additionalProjectsLabel = this.buildLabel("SESSION_MULTIPLE_PROJECTS_LIST");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)additionalProjectsLabel, constraints);
        JList additionalProjectsList = SwingComponentFactory.buildList(this.buildAddionalProjectsListAdapter());
        additionalProjectsList.setCellRenderer(this.buildAddiontalProjectsCellRenderer());
        this.selectionModel = new ObjectListSelectionModel(additionalProjectsList.getModel());
        additionalProjectsList.setSelectionModel(this.selectionModel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)new JScrollPane(additionalProjectsList), constraints);
        additionalProjectsLabel.setLabelFor(additionalProjectsList);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)buttonPanel, constraints);
        JButton addButton = this.buildButton("SESSION_MULTIPLE_PROJECTS_ADD_BUTTON");
        addButton.addActionListener(this.buildAddAction());
        buttonPanel.add(addButton);
        JButton removeButton = this.buildButton("SESSION_MULTIPLE_PROJECTS_REMOVE_BUTTON");
        removeButton.setEnabled(false);
        removeButton.addActionListener(this.buildRemoveAction());
        this.buildRemoveButtonEnabler(removeButton);
        buttonPanel.add(removeButton);
    }

    private class CellRendererAdapter
    extends AbstractCellRendererAdapter {
        private CellRendererAdapter() {
        }

        public Icon buildFileIcon(String path) {
            File file = new File(path);
            return AbstractSessionMultipleProjectsPane.this.resourceRepository().getIcon(file.exists() ? (file.isDirectory() ? "folder" : "file") : "file");
        }

        public Icon buildIcon(Object value) {
            if (value instanceof ProjectXMLAdapter) {
                return this.buildFileIcon(((ProjectXMLAdapter)((Object)value)).getName());
            }
            return AbstractSessionMultipleProjectsPane.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object value) {
            String name = ((ProjectAdapter)((Object)value)).getName();
            return name.replace('/', File.separatorChar);
        }
    }
}

