/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CustomServerPlatformAdapter
extends ServerPlatformAdapter {
    public static final String SERVER_CLASS_NAME_PROPERTY = "serverClassName";
    public static final String EXTERNAL_TRANSACTION_CONTROLLER_CLASS_PROPERTY = "externalTransactionControllerClass";

    CustomServerPlatformAdapter() {
    }

    CustomServerPlatformAdapter(SCAdapter parent, CustomServerPlatformConfig scConfig) {
        super(parent, (ServerPlatformConfig)scConfig);
    }

    protected CustomServerPlatformAdapter(SCAdapter parent) {
        super(parent);
    }

    private final CustomServerPlatformConfig platformConfig() {
        return (CustomServerPlatformConfig)this.getModel();
    }

    protected Object buildModel() {
        return new CustomServerPlatformConfig();
    }

    public boolean isCustom() {
        return true;
    }

    public String getServerClassName() {
        return this.platformConfig().getServerClassName();
    }

    public void setServerClassName(String name) {
        String old = this.platformConfig().getServerClassName();
        this.platformConfig().setServerClassName(name);
        this.firePropertyChanged(SERVER_CLASS_NAME_PROPERTY, old, name);
    }

    public String getExternalTransactionControllerClass() {
        return this.platformConfig().getExternalTransactionControllerClass();
    }

    public void setExternalTransactionControllerClass(String name) {
        String old = this.platformConfig().getExternalTransactionControllerClass();
        this.platformConfig().setExternalTransactionControllerClass(name);
        this.firePropertyChanged(EXTERNAL_TRANSACTION_CONTROLLER_CLASS_PROPERTY, old, name);
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        this.verifyExternalTransactionControllerClass(branchProblems);
        this.verifyServerClassName(branchProblems);
    }

    private void verifyExternalTransactionControllerClass(List branchProblems) {
        String className = this.getExternalTransactionControllerClass();
        if (StringTools.stringIsEmpty((String)className)) {
            branchProblems.add(this.buildProblem("0811", this.getParent().displayString()));
        }
    }

    private void verifyServerClassName(List branchProblems) {
        String className = this.getServerClassName();
        if (StringTools.stringIsEmpty((String)className)) {
            branchProblems.add(this.buildProblem("0812", this.getParent().displayString()));
        }
    }
}

