/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.EISLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginHandler;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PoolsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.XMLLoginAdapter;

public class ConnectionPoolAdapter
extends SCAdapter
implements Nominative,
LoginHandler {
    public static final String MAX_CONNECTIONS_PROPERTY = "maxConnections";
    public static final String MIN_CONNECTIONS_PROPERTY = "minConnections";
    private volatile LoginAdapter login;
    public static final String LOGIN_CONFIG_PROPERTY = "loginConfig";
    public static final String READ_CONNECTION_POOL_NAME = "ReadConnectionPool";
    public static final String SEQUENCE_CONNECTION_POOL_NAME = "SequenceConnectionPool";

    ConnectionPoolAdapter(SCAdapter parent, ConnectionPoolConfig scConfig) {
        super(parent, scConfig);
    }

    protected ConnectionPoolAdapter(SCAdapter parent, String name) {
        super(parent);
        this.initializeType(name);
    }

    private final ConnectionPoolConfig pool() {
        return (ConnectionPoolConfig)this.getModel();
    }

    protected Object buildModel() {
        return new ConnectionPoolConfig();
    }

    protected LoginAdapter buildLogin() {
        if (this.platformIsEis()) {
            return new EISLoginAdapter(this);
        }
        if (this.platformIsXml()) {
            return new XMLLoginAdapter(this);
        }
        return new DatabaseLoginAdapter(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.getLogin() != NullLoginAdapter.instance()) {
            children.add(this.getLogin());
        }
    }

    private void initializeType(String name) {
        this.setName(name);
        this.initializeTypeDefaults();
    }

    protected void initializeTypeDefaults() {
        if (this.pool().getMinConnections() == null) {
            this.setMinConnections(2);
        }
        if (this.pool().getMaxConnections() == null) {
            this.setMaxConnections(2);
        }
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.setLogin(this.buildLogin());
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.login = this.getLoginFromModel();
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (this.getName() == null) {
            this.setName("unamed");
        }
    }

    protected LoginAdapter getLoginFromModel() {
        if (this.pool().getLoginConfig() == null) {
            return NullLoginAdapter.instance();
        }
        return (LoginAdapter)this.adapt(this.pool().getLoginConfig());
    }

    public String getName() {
        return this.pool().getName();
    }

    public void setName(String name) {
        String old = this.pool().getName();
        this.pool().setName(name);
        this.firePropertyChanged("name", old, name);
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public boolean platformIsRdbms() {
        return ((PoolsAdapter)this.getParent()).platformIsRdbms();
    }

    public boolean platformIsEis() {
        return ((PoolsAdapter)this.getParent()).platformIsEis();
    }

    public boolean platformIsXml() {
        return ((PoolsAdapter)this.getParent()).platformIsXml();
    }

    public boolean isReadConnectionPool() {
        return false;
    }

    public boolean isSequenceConnectionPool() {
        return this.pool().getName().equals(SEQUENCE_CONNECTION_POOL_NAME);
    }

    public boolean isWriteConnectionPool() {
        return false;
    }

    public void setMaxConnections(int maxConnections) {
        int oldMaxConnections = this.getMaxConnections();
        this.pool().setMaxConnections(new Integer(maxConnections));
        this.firePropertyChanged(MAX_CONNECTIONS_PROPERTY, oldMaxConnections, maxConnections);
    }

    public int getMaxConnections() {
        Integer max = this.pool().getMaxConnections();
        return max == null ? 0 : max;
    }

    public void setMinConnections(int minConnections) {
        int oldMinConnections = this.getMinConnections();
        this.pool().setMinConnections(new Integer(minConnections));
        this.firePropertyChanged(MIN_CONNECTIONS_PROPERTY, oldMinConnections, minConnections);
    }

    public int getMinConnections() {
        Integer min = this.pool().getMinConnections();
        return min == null ? 0 : min;
    }

    public LoginAdapter getLogin() {
        return this.login;
    }

    protected void setLogin(LoginAdapter login) {
        LoginAdapter old = this.login;
        this.login = login;
        this.pool().setLoginConfig((LoginConfig)this.login.getModel());
        this.firePropertyChanged(LOGIN_CONFIG_PROPERTY, old, this.login);
    }

    protected void removeLogin() {
        this.setLogin(NullLoginAdapter.instance());
    }

    public void setExternalConnectionPooling(boolean value) {
    }

    public boolean usesExternalConnectionPooling() {
        return false;
    }
}

