/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.type;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.type.DatabaseTypeNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

final class RenameDatabaseTypeAction
extends AbstractFrameworkAction {
    public RenameDatabaseTypeAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("RENAME_DATABASE_TYPE");
        this.initializeIcon("RENAME_DATABASE_TYPE");
        this.initializeToolTipText("RENAME_DATABASE_TYPE.TOOL_TIP");
    }

    protected void execute() {
        TreePath[] paths = this.navigatorSelectionModel().getSelectionPaths();
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] nodes = this.selectedNodes();
        int i = nodes.length;
        while (i-- > 0) {
            this.execute(((DatabaseTypeNode)nodes[i]).getDatabaseType(), builder);
        }
        this.navigatorSelectionModel().setSelectionPaths(paths);
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("RENAME_DATABASE_TYPE_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_DATABASE_TYPE_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbTypeRename");
        return builder;
    }

    protected void execute(DatabaseType dbType, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingTypeNames(dbType.getPlatform()));
        builder.setOriginalName(dbType.getName());
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            dbType.setName(dialog.getNewName());
        }
    }

    private Iterator existingTypeNames(DatabasePlatform platform) {
        return new TransformationIterator(platform.databaseTypes()){

            protected Object transform(Object next) {
                return ((DatabaseType)next).getName();
            }
        };
    }
}

