/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.NullParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ElementDeclarationNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ModelGroupNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.NullNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SpecificParticleNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.WildcardNodeStructure;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class GeneralParticleNodeStructure
extends SchemaComponentNodeStructure {
    private SpecificParticleNodeStructure specificParticleStructure;

    GeneralParticleNodeStructure(MWParticle particle) {
        super((MWSchemaComponent)particle);
        this.specificParticleStructure = this.buildSpecificParticleStructure(particle);
    }

    private SpecificParticleNodeStructure buildSpecificParticleStructure(MWParticle particle) {
        SchemaComponentNodeStructure specificParticleStructure;
        if (particle instanceof MWElementDeclaration) {
            specificParticleStructure = new ElementDeclarationNodeStructure((MWElementDeclaration)particle);
        } else if (particle instanceof MWModelGroup) {
            specificParticleStructure = new ModelGroupNodeStructure((MWModelGroup)particle);
        } else if (particle instanceof Wildcard) {
            specificParticleStructure = new WildcardNodeStructure((Wildcard)particle);
        } else if (particle instanceof NullParticle) {
            specificParticleStructure = new NullNodeStructure((NullParticle)particle);
        } else {
            throw new IllegalArgumentException("Unsupported particle type.");
        }
        specificParticleStructure.addPropertyChangeListener("displayString", this.buildDisplayStringChangeListener());
        return specificParticleStructure;
    }

    private PropertyChangeListener buildDisplayStringChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GeneralParticleNodeStructure.this.firePropertyChanged("displayString", evt.getOldValue(), evt.getNewValue());
            }
        };
    }

    void disengageComponent() {
        super.disengageComponent();
        this.specificParticleStructure.disengageParticle();
    }

    public String displayString() {
        return this.specificParticleStructure.displayString();
    }

    protected ListIterator componentDetails() {
        SchemaComponentDetail[] details = new SchemaComponentDetail[]{this.buildMinOccursDetail(), this.buildMaxOccursDetail()};
        return this.specificParticleStructure.details(CollectionTools.listIterator((Object[])details));
    }

    SchemaComponentDetail buildMinOccursDetail() {
        return new SchemaComponentDetail(this.getComponent()){

            protected String getName() {
                return "minOccurs";
            }

            protected String getValueFromComponent() {
                return String.valueOf(((MWParticle)this.component).getMinOccurs());
            }
        };
    }

    SchemaComponentDetail buildMaxOccursDetail() {
        return new SchemaComponentDetail(this.getComponent()){

            protected String getName() {
                return "maxOccurs";
            }

            protected String getValueFromComponent() {
                int maxOccurs = ((MWParticle)this.component).getMaxOccurs();
                return maxOccurs == 0x7FFFFFF8 ? "unbounded" : String.valueOf(maxOccurs);
            }
        };
    }
}

