/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

class OrderingAttributeDialog
extends AttributeItemDialog {
    private JComboBox orderComboBox;

    OrderingAttributeDialog(MWOrderableQuery query, Ordering item, Filter traversableFilter, Filter chooseableFilter, WorkbenchContext context) {
        super((MWQuery)query, (MWAttributeItem)item, traversableFilter, chooseableFilter, context);
    }

    protected String titleKey() {
        return "ORDERING_ATTRIBUTES_DIALOG_TITLE";
    }

    protected String editTitleKey() {
        return "ORDERING_ATTRIBUTES_EDIT_DIALOG_TITLE";
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.query.orderingAttributes";
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.buildQueryableTree());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)scrollPane, constraints);
        JComboBox orderComboBox = this.buildOrderComboBox();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)orderComboBox, constraints);
        return panel;
    }

    protected void initializeEditMode(MWAttributeItem attributeItem) {
        super.initializeEditMode(attributeItem);
        this.initializeOrderComboBox(attributeItem);
    }

    protected void initializeOrderComboBox(MWAttributeItem attributeItem) {
        if (((Ordering)attributeItem).isAscending()) {
            this.orderComboBox.setSelectedItem(this.resourceRepository().getString("ASCENDING_CHOICE"));
        } else {
            this.orderComboBox.setSelectedItem(this.resourceRepository().getString("DESCENDING_CHOICE"));
        }
    }

    protected JComboBox buildOrderComboBox() {
        this.orderComboBox = new JComboBox();
        this.orderComboBox.addItem(this.resourceRepository().getString("ASCENDING_CHOICE"));
        this.orderComboBox.addItem(this.resourceRepository().getString("DESCENDING_CHOICE"));
        return this.orderComboBox;
    }

    boolean isAscending() {
        return this.orderComboBox.getSelectedItem().equals(this.resourceRepository().getString("ASCENDING_CHOICE"));
    }

    protected int attributeItemsSize() {
        return ((MWOrderableQuery)this.getQuery()).orderingItemsSize();
    }

    protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
        return ((MWOrderableQuery)this.getQuery()).indexOfOrderingItem((Ordering)attributeItem);
    }

    protected void removeAttributeItem(int index) {
        ((MWOrderableQuery)this.getQuery()).removeOrderingItem(index);
    }

    protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
        Ordering item = ((MWOrderableQuery)this.getQuery()).addOrderingItem(index, queryables, allowsNulls);
        item.setAscending(this.isAscending());
    }
}

