/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomStoredProcedureQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StringQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public final class CustomQuerySelectionCriteriaPanel
extends AbstractPanel {
    private QueryFormatPanel queryFormatPanel;
    private Map<Class<? extends MWQueryFormat>, JComponent> queryFormatPanelMap;
    private PropertyValueModel queryHolder;

    public CustomQuerySelectionCriteriaPanel(PropertyValueModel queryHolder, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.addHelpTopicId(this, this.helpTopicId());
        this.queryHolder = queryHolder;
        this.initializeLayout();
    }

    private Transformer buildPaneTransformer() {
        return new Transformer(){

            public JComponent transform(Object queryFormat) {
                if (queryFormat == null) {
                    return null;
                }
                return (JComponent)CustomQuerySelectionCriteriaPanel.this.queryFormatPanelMap.get(queryFormat.getClass());
            }
        };
    }

    private PropertyValueModel buildQueryFormatHolder() {
        return new PropertyAspectAdapter(this.buildRelationalOptionsHolder(), "queryFormatType"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getQueryFormat();
            }
        };
    }

    private ValueModel buildRelationalOptionsHolder() {
        return new TransformationValueModel(this.buildRelationalQueryHolder()){

            protected Object transformNonNull(Object value) {
                return ((MWRelationalQuery)value).getRelationalOptions();
            }
        };
    }

    private ValueModel buildRelationalQueryHolder() {
        return new TransformationValueModel(this.queryHolder){

            protected Object transformNonNull(Object value) {
                return value;
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.queries.format";
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.initializeMaps();
        SwitcherPanel switcherPane = new SwitcherPanel(this.buildQueryFormatHolder(), this.buildPaneTransformer());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)switcherPane, constraints);
    }

    private void initializeMaps() {
        this.queryFormatPanel = new QueryFormatPanel(this.queryHolder, this.buildQueryFormatHolder(), this.getWorkbenchContextHolder());
        this.queryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
        this.queryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.queryFormatPanel);
        this.queryFormatPanelMap.put(MWSQLQueryFormat.class, this.queryFormatPanel);
        this.queryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.queryFormatPanel);
    }

    private boolean promptToChangeSelectionCriteriaType() {
        if (this.preferences().getBoolean("query change query format", false)) {
            return true;
        }
        String title = this.resourceRepository().getString("QUERY_QUERY_FORMAT_TITLE");
        String message = this.resourceRepository().getString("QUERY_QUERY_FORMAT_MESSAGE");
        SimplePropertyValueModel dontAskAgainHolder = new SimplePropertyValueModel(new Boolean(false));
        JComponent dontAskAgainPanel = SwingComponentFactory.buildDoNotAskAgainPanel(message, dontAskAgainHolder, this.resourceRepository());
        int response = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), dontAskAgainPanel, title, 0, 2);
        if (dontAskAgainHolder.getValue().equals(Boolean.TRUE)) {
            if (response == 0) {
                this.preferences().putBoolean("query change query format", true);
            } else if (response == 1) {
                this.preferences().putBoolean("query change query format", false);
            }
        }
        return response == 0;
    }

    private boolean queryFormatCanChange() {
        boolean changeQueryType;
        String promptValue = TriStateBoolean.UNDEFINED.toString();
        String value = this.preferences().get("query change query format", "undefined");
        if (value.equals(promptValue)) {
            changeQueryType = this.promptToChangeSelectionCriteriaType();
        } else {
            changeQueryType = TriStateBoolean.TRUE.toString().equals(value);
            if (!changeQueryType) {
                JOptionPane.showMessageDialog(this.getRootPane(), this.resourceRepository().getString("QUERY_FORMAT_CHANGE_DISSALLOWED"), this.application().getShortProductName(), 1);
            }
        }
        return changeQueryType;
    }

    private final class QueryFormatPanel
    extends AbstractQueryFormatPanel {
        private CustomStoredProcedureQueryFormatSubPanel storedProcedurePanel;
        private StringQueryFormatSubPanel stringQueryFormatPanel;
        private Map<Class<? extends MWQueryFormat>, JComponent> subQueryFormatPanelMap;

        public QueryFormatPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(queryHolder, queryFormatHolder, workbenchContextHolder);
            this.initializeLayout();
        }

        private ValueModel buildStoredProcedureQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value instanceof MWStoredProcedureQueryFormat ? (MWStoredProcedureQueryFormat)value : null;
                }
            };
        }

        private Transformer buildPaneTransformer() {
            return new Transformer(){

                public JComponent transform(Object queryFormat) {
                    if (queryFormat == null) {
                        return null;
                    }
                    return (JComponent)QueryFormatPanel.this.subQueryFormatPanelMap.get(queryFormat.getClass());
                }
            };
        }

        private ValueModel buildQueryComponentEnableBooleanHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value != null;
                }
            };
        }

        private PropertyValueModel buildQueryFormatTypeHolder() {
            return new PropertyAspectAdapter(CustomQuerySelectionCriteriaPanel.this.buildRelationalOptionsHolder(), "queryFormatType"){

                protected Object getValueFromSubject() {
                    return ((MWRelationalQuery)this.subject).getQueryFormatType();
                }

                protected void setValueOnSubject(Object value) {
                    if (CustomQuerySelectionCriteriaPanel.this.queryFormatCanChange()) {
                        ((MWRelationalQuery)this.subject).setQueryFormatType((String)value);
                    }
                }
            };
        }

        private ListCellRenderer buildSelectionCriteraCellRenderer() {
            return new SimpleListCellRenderer(){

                public String buildText(Object value) {
                    if (value == "storedProcedure") {
                        return QueryFormatPanel.this.resourceRepository().getString("STORED_PROCEDURE_OPTION");
                    }
                    if (value == "sqlFormat") {
                        return QueryFormatPanel.this.resourceRepository().getString("SQL_OPTION");
                    }
                    return QueryFormatPanel.this.resourceRepository().getString("EJBQL_OPTION");
                }
            };
        }

        private ComboBoxModel buildSelectionCriteriaComboModel() {
            return new ComboBoxModelAdapter(this.selectionCriteriaOptionsModel(), this.buildQueryFormatTypeHolder());
        }

        private ValueModel buildStringQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object value) {
                    return value instanceof MWStringQueryFormat ? (MWStringQueryFormat)value : null;
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            this.initializeMaps();
            JComponent queryFormatTypeWidgets = this.buildLabeledComboBox("SELECTION_CRITERIA_TYPE_LABEL", this.buildSelectionCriteriaComboModel(), this.buildSelectionCriteraCellRenderer());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)queryFormatTypeWidgets, constraints);
            new ComponentEnabler(this.buildQueryComponentEnableBooleanHolder(), queryFormatTypeWidgets);
            SwitcherPanel switcherPane = new SwitcherPanel(this.queryFormatHolder, this.buildPaneTransformer());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)switcherPane, constraints);
        }

        private void initializeMaps() {
            this.stringQueryFormatPanel = new StringQueryFormatSubPanel(this.buildStringQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.storedProcedurePanel = new CustomStoredProcedureQueryFormatSubPanel(this.buildStoredProcedureQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.subQueryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
            this.subQueryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.storedProcedurePanel);
            this.subQueryFormatPanelMap.put(MWSQLQueryFormat.class, this.stringQueryFormatPanel);
            this.subQueryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.stringQueryFormatPanel);
        }

        private CollectionValueModel selectionCriteriaOptionsModel() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("storedProcedure");
            options.add("sqlFormat");
            options.add("ejbqlFormat");
            return new ReadOnlyCollectionValueModel(options);
        }
    }

    private abstract class AbstractQueryFormatPanel
    extends AbstractPanel {
        protected PropertyValueModel queryHolder;
        protected PropertyValueModel queryFormatHolder;

        protected AbstractQueryFormatPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder workbenchContextHolder) {
            super(workbenchContextHolder);
            this.queryFormatHolder = queryFormatHolder;
            this.queryHolder = queryHolder;
        }
    }
}

