/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;

class AddQueryDialog
extends AbstractDialog
implements CaretListener,
ActionListener {
    private boolean supportsReportQuery;
    private ButtonGroup typeButtonGroup;
    private JTextField nameTextField;
    private JRadioButton readObjectQueryRadioButton;
    private JRadioButton readAllQueryRadioButton;
    private JRadioButton reportQueryRadioButton;

    protected AddQueryDialog(WorkbenchContext context, boolean supportsReportQuery) {
        super(context);
        this.supportsReportQuery = supportsReportQuery;
    }

    protected Component buildMainPanel() {
        JPanel messagePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildQueryTypePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        messagePanel.add((Component)buttonPanel, constraints);
        this.helpManager().addTopicID(buttonPanel, this.helpTopicId() + ".type");
        JPanel namePanel = this.buildNamePanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 5);
        messagePanel.add((Component)namePanel, constraints);
        this.helpManager().addTopicID(namePanel, this.helpTopicId() + ".name");
        this.getOKAction().setEnabled(false);
        return messagePanel;
    }

    protected JPanel buildQueryTypePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TYPE_BORDER_LABEL_ON_ADD_QUERY_DIALOG")));
        this.typeButtonGroup = new ButtonGroup();
        this.readObjectQueryRadioButton = new JRadioButton(this.resourceRepository().getString("READ_OBJECT_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.readObjectQueryRadioButton.setSelected(true);
        this.readObjectQueryRadioButton.addActionListener(this);
        this.readObjectQueryRadioButton.setActionCommand("READ_OBJECT_QUERY");
        this.typeButtonGroup.add(this.readObjectQueryRadioButton);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.readObjectQueryRadioButton, constraints);
        this.readAllQueryRadioButton = new JRadioButton(this.resourceRepository().getString("READ_ALL_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.readAllQueryRadioButton.addActionListener(this);
        this.readAllQueryRadioButton.setActionCommand("READ_ALL_QUERY");
        this.typeButtonGroup.add(this.readAllQueryRadioButton);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.readAllQueryRadioButton, constraints);
        if (this.supportsReportQuery()) {
            this.reportQueryRadioButton = new JRadioButton(this.resourceRepository().getString("REPORT_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
            this.reportQueryRadioButton.addActionListener(this);
            this.reportQueryRadioButton.setActionCommand("REPORT_QUERY");
            this.typeButtonGroup.add(this.reportQueryRadioButton);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 0, 0);
            panel.add((Component)this.reportQueryRadioButton, constraints);
        }
        return panel;
    }

    protected void enableQueryTypePanel(boolean enabled) {
        this.readAllQueryRadioButton.setEnabled(enabled);
        this.readObjectQueryRadioButton.setEnabled(enabled);
        if (this.supportsReportQuery()) {
            this.reportQueryRadioButton.setEnabled(enabled);
        }
    }

    protected JPanel buildNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel nameLabel = new JLabel(this.resourceRepository().getString("NAME_TEXT_FIELD_LABEL_ON_ADD_QUERY_DIALOG"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 5);
        namePanel.add((Component)nameLabel, constraints);
        this.nameTextField = new JTextField();
        this.nameTextField.setDocument(new RegexpDocument(5));
        this.nameTextField.addCaretListener(this);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        namePanel.add((Component)this.nameTextField, constraints);
        return namePanel;
    }

    public void actionPerformed(ActionEvent ae) {
        this.getNameTextField().requestFocus();
        this.validateQuery();
    }

    public void caretUpdate(CaretEvent ce) {
        this.validateQuery();
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.namedQueries";
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADD_QUERY_DIALOG.title"));
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }

    protected JTextField getNameTextField() {
        return this.nameTextField;
    }

    protected void setQueryType(String queryType) {
        if (queryType == "READ_OBJECT_QUERY") {
            this.readObjectQueryRadioButton.setSelected(true);
        } else if (queryType == "READ_ALL_QUERY") {
            this.readAllQueryRadioButton.setSelected(true);
        } else {
            this.reportQueryRadioButton.setSelected(true);
        }
    }

    protected void validateQuery() {
        String queryName = this.getQueryName();
        boolean enabled = queryName != null;
        this.getOKAction().setEnabled(enabled &= !queryName.equals(""));
    }

    private boolean supportsReportQuery() {
        return this.supportsReportQuery;
    }

    public String getQueryName() {
        return this.nameTextField.getText();
    }

    public String getQueryType() {
        return this.typeButtonGroup.getSelection().getActionCommand();
    }
}

