/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ReferenceCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.NewTableReferenceDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

abstract class AbstractTableReferencePanel
extends AbstractSubjectPanel {
    AbstractTableReferencePanel(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    private ActionListener buildCreateNewReferenceAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractTableReferencePanel.this.createNewReference();
            }
        };
    }

    protected ColumnPairsPanel buildColumnPairsPanel() {
        return new ColumnPairsPanel(this.getWorkbenchContextHolder(), this.buildTableReferenceHolder());
    }

    private ListChooser buildTableReferenceChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildExtendedTableReferenceComboBoxModel(), this.getWorkbenchContextHolder(), this.buildTableReferenceNodeSelector(), this.buildTableReferenceChooserDialogBuilder());
        listChooser.setRenderer(this.buildReferenceListRenderer());
        return listChooser;
    }

    protected CachingComboBoxModel buildExtendedTableReferenceComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildTableReferenceHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object subject) {
                return AbstractTableReferencePanel.this.orderedReferenceChoices((MWTableReferenceMapping)subject);
            }
        });
    }

    protected ListIterator orderedReferenceChoices(MWTableReferenceMapping mapping) {
        return CollectionTools.sort((Iterator)this.candidateReferences(mapping)).listIterator();
    }

    protected Iterator candidateReferences(MWTableReferenceMapping mapping) {
        return mapping.candidateReferences();
    }

    private DefaultListChooserDialog.Builder buildTableReferenceChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("TABLE_REFERENCE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("TABLE_REFERENCE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableReferenceStringConverter());
        return builder;
    }

    private ListCellRenderer buildReferenceListRenderer() {
        return new AdaptableListCellRenderer(new ReferenceCellRendererAdapter(this.resourceRepository()));
    }

    private StringConverter buildTableReferenceStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWReference)o).getName();
            }
        };
    }

    protected PropertyValueModel buildTableReferenceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "reference"){

            protected Object getValueFromSubject() {
                return ((MWTableReferenceMapping)this.subject).getReference();
            }

            protected void setValueOnSubject(Object value) {
                ((MWTableReferenceMapping)this.subject).setReference((MWReference)value);
            }
        };
    }

    private NodeSelector buildTableReferenceNodeSelector() {
        return new NodeSelector(){

            public void selectNodeFor(Object item) {
                RelationalProjectNode projectNode = (RelationalProjectNode)AbstractTableReferencePanel.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectReference((MWReference)item, AbstractTableReferencePanel.this.getWorkbenchContext());
            }
        };
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        ListChooser tableReferenceChooser = this.buildTableReferenceChooser();
        JButton newReferenceButton = this.buildButton("TABLE_REFERENCE_NEW_BUTTON");
        newReferenceButton.addActionListener(this.buildCreateNewReferenceAction());
        JComponent tableReferenceWidgets = this.buildLabeledComponent("TABLE_REFERENCE_CHOOSER", tableReferenceChooser, newReferenceButton);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)tableReferenceWidgets, constraints);
        ColumnPairsPanel columnPairsPanel = this.buildColumnPairsPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)columnPairsPanel, constraints);
        this.addPaneForAlignment(columnPairsPanel);
        JButton button = new JButton("Test");
        int height = button.getPreferredSize().height * 4 + 20;
        columnPairsPanel.setPreferredSize(new Dimension(1, height));
        this.addHelpTopicId(this, "mapping.tableReference");
    }

    void createNewReference() {
        NewTableReferenceDialog dialog = NewTableReferenceDialog.buildReferenceDialogAllowSourceAndTargetSelection(this.getWorkbenchContext(), this.candidateNewReferenceSourceTables(), this.candidateNewReferenceTargetTables());
        dialog.setSourceTable(this.defaultNewReferenceSourceTable());
        dialog.setTargetTable(this.defaultNewReferenceTargetTable());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        MWTable sourceTable = dialog.getSourceTable();
        MWReference reference = sourceTable.addReference(dialog.getReferenceName(), dialog.getTargetTable());
        reference.setOnDatabase(dialog.isOnDatabase());
        this.setReference(reference);
    }

    protected List candidateNewReferenceSourceTables() {
        return this.allTables();
    }

    protected abstract MWTable defaultNewReferenceSourceTable();

    protected List candidateNewReferenceTargetTables() {
        return this.allTables();
    }

    protected abstract MWTable defaultNewReferenceTargetTable();

    protected void setReference(MWReference reference) {
        ((MWTableReferenceMapping)this.subject()).setReference(reference);
    }

    protected List allTables() {
        return CollectionTools.sort((Iterator)((MWModel)this.subject()).getDatabase().tables());
    }
}

