/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWRefreshCachePolicy;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

final class RefreshCachePolicyPanel
extends AbstractPanel {
    private PropertyValueModel refreshCachePolicyHolder;

    RefreshCachePolicyPanel(ApplicationContext context, PropertyValueModel refreshCachePolicyHolder) {
        super(context);
        this.refreshCachePolicyHolder = refreshCachePolicyHolder;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("REFRESH_CACHE_POLICY_PANEL_BORDER_TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JCheckBox alwaysRefreshCacheCheckBox = this.buildAlwaysRefreshCacheCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)alwaysRefreshCacheCheckBox, constraints);
        JCheckBox onlyRefreshCacheIfNewerVersionCheckBox = this.buildOnlyRefreshCacheIfNewerVersionCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)onlyRefreshCacheIfNewerVersionCheckBox, constraints);
        JCheckBox shouldDisableCacheHits = this.buildDisableCacheHitsCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)shouldDisableCacheHits, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private String helpTopicId() {
        return "descriptor.transactional.refreshCache";
    }

    private JCheckBox buildAlwaysRefreshCacheCheckBox() {
        JCheckBox checkBox = this.buildCheckBox("REFRESH_CACHE_POLICY_PANEL_ALWAYS_REFRESH_CACHE_CHECK_BOX", this.buildAlwaysRefreshCacheCheckBoxModel());
        this.addHelpTopicId(checkBox, this.helpTopicId() + "alwaysRefresh");
        return checkBox;
    }

    private ButtonModel buildAlwaysRefreshCacheCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildAlwaysRefreshCacheAdapter());
    }

    private PropertyValueModel buildAlwaysRefreshCacheAdapter() {
        return new PropertyAspectAdapter(this.refreshCachePolicyHolder, "alwaysRefreshCache"){

            protected Object getValueFromSubject() {
                return ((MWRefreshCachePolicy)this.subject).isAlwaysRefreshCache();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRefreshCachePolicy)this.subject).setAlwaysRefreshCache(((Boolean)value).booleanValue());
            }
        };
    }

    private JCheckBox buildOnlyRefreshCacheIfNewerVersionCheckBox() {
        JCheckBox checkBox = this.buildCheckBox("REFRESH_CACHE_POLICY_PANEL_ONLY_REFRESH_IF_NEWER_VERSION_CHECK_BOX", this.buildOnlyRefreshCacheIfeCheckBoxModel());
        this.addHelpTopicId(checkBox, this.helpTopicId() + "onlyRefreshIfNewerVersion");
        return checkBox;
    }

    private ButtonModel buildOnlyRefreshCacheIfeCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildOnlyRefreshCacheIfNewerVersionAdapter());
    }

    private PropertyValueModel buildOnlyRefreshCacheIfNewerVersionAdapter() {
        return new PropertyAspectAdapter(this.refreshCachePolicyHolder, "onlyRefreshCacheIfNewerVersion"){

            protected Object getValueFromSubject() {
                return ((MWRefreshCachePolicy)this.subject).isOnlyRefreshCacheIfNewerVersion();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRefreshCachePolicy)this.subject).setOnlyRefreshCacheIfNewerVersion(((Boolean)value).booleanValue());
            }
        };
    }

    private JCheckBox buildDisableCacheHitsCheckBox() {
        JCheckBox checkBox = this.buildCheckBox("REFRESH_CACHE_POLICY_PANEL_SHOULD_DISABLE_CACHE_HITS_CHECK_BOX", this.buildDisableCacheHitsCheckBoxModel());
        this.addHelpTopicId(checkBox, this.helpTopicId() + "disableCacheHits");
        return checkBox;
    }

    private ButtonModel buildDisableCacheHitsCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildDisableCacheHitsAdapter());
    }

    private PropertyValueModel buildDisableCacheHitsAdapter() {
        return new PropertyAspectAdapter(this.refreshCachePolicyHolder, "disableCacheHits"){

            protected Object getValueFromSubject() {
                return ((MWRefreshCachePolicy)this.subject).isDisableCacheHits();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRefreshCachePolicy)this.subject).setDisableCacheHits(((Boolean)value).booleanValue());
            }
        };
    }
}

