/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;

final class HierarchyClassSelector
extends AbstractDialog {
    private MWClass leafClass;
    private MWClass selectedClass;
    private JTree hierarchyTree;

    HierarchyClassSelector(MWClass leafClass, WorkbenchContext context) throws ClassNotFoundException {
        super(context);
        this.leafClass = leafClass;
    }

    MWClass getSelectedClass() {
        return this.selectedClass;
    }

    protected String helpTopicId() {
        return "descriptor.hierarchyClassSelector";
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        this.setTitle(this.resourceRepository().getString("HIERARCHY_CLASS_SELECTOR_DIALOG.title"));
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel hierarchyLabel = new JLabel(this.resourceRepository().getString("HIERARCHY_CLASS_SELECTOR_DIALOG_LABEL"));
        hierarchyLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("HIERARCHY_CLASS_SELECTOR_DIALOG_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)hierarchyLabel, constraints);
        this.initializeHierarchyTree();
        JScrollPane hierarchyPane = new JScrollPane(this.hierarchyTree);
        hierarchyPane.setPreferredSize(new Dimension(200, 200));
        hierarchyLabel.setLabelFor(this.hierarchyTree);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)hierarchyPane, constraints);
        return panel;
    }

    private void initializeHierarchyTree() {
        MWClass currentClass;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setAllowsChildren(true);
        this.hierarchyTree = SwingComponentFactory.buildTree(new DefaultTreeModel(root));
        this.hierarchyTree.setCellRenderer(this.buildMWClassCellRenderer());
        this.hierarchyTree.setRootVisible(false);
        this.hierarchyTree.setShowsRootHandles(true);
        this.hierarchyTree.setRowHeight(20);
        this.hierarchyTree.setDoubleBuffered(true);
        this.hierarchyTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                TreePath path = ((JTree)event.getSource()).getLeadSelectionPath();
                if (path != null) {
                    HierarchyClassSelector.this.hierarchyTree.setSelectionPaths(new TreePath[]{path});
                    MWClass bldrClass = (MWClass)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    HierarchyClassSelector.this.setSelectedClass(bldrClass);
                } else {
                    HierarchyClassSelector.this.setSelectedClass(null);
                }
            }
        });
        Stack<MWClass> classStack = new Stack<MWClass>();
        MWClassRepository repos = currentClass.getRepository();
        for (currentClass = this.leafClass; currentClass != repos.typeFor(Object.class); currentClass = currentClass.getSuperclass()) {
            classStack.push(currentClass);
        }
        DefaultMutableTreeNode nextParentNode = null;
        while (!classStack.empty()) {
            MWClass nextClass = (MWClass)classStack.pop();
            DefaultMutableTreeNode nextClassNode = new DefaultMutableTreeNode(nextClass);
            if (root.getChildCount() == 0) {
                root.add(nextClassNode);
            } else {
                nextParentNode.add(nextClassNode);
            }
            nextParentNode = nextClassNode;
        }
        ((DefaultTreeModel)this.hierarchyTree.getModel()).reload();
        this.hierarchyTree.expandPath(new TreePath(nextParentNode.getPath()));
    }

    protected Component initialFocusComponent() {
        return this.hierarchyTree;
    }

    private TreeCellRenderer buildMWClassCellRenderer() {
        return new SimpleTreeCellRenderer(){

            protected String buildText(Object value) {
                MWClass mwClass = (MWClass)((DefaultMutableTreeNode)value).getUserObject();
                return mwClass == null ? "" : mwClass.getName();
            }

            protected Icon buildIcon(Object value) {
                return null;
            }
        };
    }

    protected void setSelectedClass(MWClass newSelectedClass) {
        this.selectedClass = newSelectedClass;
        this.getOKAction().setEnabled(newSelectedClass != null);
    }
}

