/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class DescriptorCreationFailuresDialog
extends StatusDialog {
    private final DescriptorCreationFailureContainer failures;

    public DescriptorCreationFailuresDialog(DescriptorCreationFailureContainer failures, WorkbenchContext context) {
        super(context.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class), DescriptorCreationFailuresDialog.buildStatus(failures), "ERROR_CREATING_DESCRIPTORS_TITLE", "XML_PROJECTS_DONT_SUPPORT_INTERFACE_DESCRIPTORS_MESSAGE", "dialog.descriptorsNotCreated");
        this.failures = failures;
    }

    private static Collection buildStatus(DescriptorCreationFailureContainer failures) {
        SortedSet failuresSet = CollectionTools.sortedSet((Iterator)failures.failureEvents(), (Comparator)new Comparator(){

            public int compare(Object object1, Object object2) {
                DescriptorCreationFailureEvent event1 = (DescriptorCreationFailureEvent)object1;
                DescriptorCreationFailureEvent event2 = (DescriptorCreationFailureEvent)object2;
                return event1.getClassName().compareTo(event2.getClassName());
            }
        });
        Vector<StatusDialog.Status> statusList = new Vector<StatusDialog.Status>(failuresSet.size());
        for (DescriptorCreationFailureEvent event : failuresSet) {
            Error error = new Error(event);
            StatusDialog.Status status = StatusDialog.createStatus((Object)event.getClassName(), Collections.singletonList(error));
            statusList.add(status);
        }
        return statusList;
    }

    protected CellRendererAdapter buildNodeRenderer(Object value) {
        if (value instanceof String) {
            return new ClassNameCellRendererAdapter();
        }
        if (value instanceof Error) {
            return new ErrorCellRendererAdapter();
        }
        return super.buildNodeRenderer(value);
    }

    protected boolean preConfirm() {
        Iterator failureEvents = this.failures.failureEvents();
        while (failureEvents.hasNext()) {
            DescriptorCreationFailureEvent event = (DescriptorCreationFailureEvent)failureEvents.next();
            Object source = event.getSource();
            if (!(source instanceof MWDescriptor)) continue;
            ((MWDescriptor)source).getProject().removeDescriptor((MWDescriptor)source);
        }
        return super.preConfirm();
    }

    private class ErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        private ErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object value) {
            return DescriptorCreationFailuresDialog.this.resourceRepository().getIcon("error");
        }

        public String buildText(Object value) {
            return ((Error)value).getErrorMessage(DescriptorCreationFailuresDialog.this.resourceRepository());
        }
    }

    private static class Error {
        private String errorMessage;
        private final DescriptorCreationFailureEvent event;

        Error(DescriptorCreationFailureEvent event) {
            this.event = event;
        }

        private String buildErrorMessage(StringRepository repository) {
            return repository.getString(this.event.getResourceStringKey());
        }

        public String getErrorMessage(StringRepository repository) {
            if (this.errorMessage == null) {
                this.errorMessage = this.buildErrorMessage(repository);
            }
            return this.errorMessage;
        }
    }

    protected class ClassNameCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected ClassNameCellRendererAdapter() {
        }

        public Icon buildIcon(Object value) {
            return DescriptorCreationFailuresDialog.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object value) {
            String className = (String)value;
            if (className.indexOf(".") == -1) {
                return className + " " + DescriptorCreationFailuresDialog.this.resourceRepository().getString("DEFAULT_PACKAGE");
            }
            return ClassTools.shortNameForClassNamed((String)className) + " (" + ClassTools.packageNameForClassNamed((String)className) + ")";
        }
    }
}

