/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.NewTableReferenceDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ReferencesPropertiesPage
extends ScrollablePropertiesPage {
    private ListValueModel targetTablesHolder;
    ListValueModel sortedReferencesAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedReferenceHolder;
    private Action removeAction;
    private Action renameAction;
    JTable table;

    public ReferencesPropertiesPage(PropertyValueModel tableNodeHolder, WorkbenchContextHolder contextHolder) {
        super(tableNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.targetTablesHolder = RelationalProjectComponentFactory.buildExtendedTablesHolder(this.getSelectionHolder());
        this.sortedReferencesAdapter = this.buildSortedReferencesAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedReferenceHolder = this.buildSelectedReferenceHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
        this.getSelectionHolder().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (ReferencesPropertiesPage.this.table.isEditing()) {
                    ReferencesPropertiesPage.this.table.getCellEditor().cancelCellEditing();
                }
                if (ReferencesPropertiesPage.this.sortedReferencesAdapter.size() > 0) {
                    ReferencesPropertiesPage.this.setSelectedReference((MWReference)ReferencesPropertiesPage.this.sortedReferencesAdapter.getItem(0));
                }
            }
        });
    }

    protected String helpTopicId() {
        return "table.references";
    }

    private ListValueModel buildSortedReferencesAdapter() {
        return new SortedListValueModelAdapter(this.buildReferenceNameAdapter());
    }

    private ListValueModel buildReferenceNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildReferencesAdapter(), "name");
    }

    private CollectionValueModel buildReferencesAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "references"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).references();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).referencesSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedReferencesAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ReferencesColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedReferenceHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel model = new ObjectListSelectionModel(new ListModelAdapter(this.sortedReferencesAdapter));
        model.addListSelectionListener(this.buildRowSelectionListener());
        model.setSelectionMode(0);
        return model;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ReferencesPropertiesPage.this.rowSelectionChanged();
                }
            }
        };
    }

    void rowSelectionChanged() {
        Object selection = this.rowSelectionModel.getSelectedValue();
        this.selectedReferenceHolder.setValue(selection);
        boolean referenceSelected = selection != null;
        this.removeAction.setEnabled(referenceSelected);
        this.renameAction.setEnabled(referenceSelected);
    }

    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)buttonPanel, constraints);
        this.table = this.buildTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        scrollPane.getViewport().setBackground(this.table.getBackground());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 0);
        mainPanel.add((Component)scrollPane, constraints);
        ColumnPairsPanel fieldAssociationPage = this.buildFieldAssociationsPanel();
        this.addHelpTopicId(fieldAssociationPage, this.helpTopicId() + ".associations");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)fieldAssociationPage, constraints);
        this.addPaneForAlignment(fieldAssociationPage);
        this.addHelpTopicId(mainPanel, this.helpTopicId());
        return mainPanel;
    }

    private JTable buildTable() {
        JTable t = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        t.getTableHeader().setReorderingAllowed(false);
        int rowHeight = 20;
        TableColumn column = t.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer targetTableRenderer = this.buildTargetTableComboBoxRenderer();
        column.setCellRenderer(targetTableRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildTargetTableComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, targetTableRenderer.getPreferredHeight());
        column = t.getColumnModel().getColumn(2);
        CheckBoxTableCellRenderer onDatabaseRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer(onDatabaseRenderer);
        column.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        rowHeight = Math.max(rowHeight, onDatabaseRenderer.getPreferredHeight());
        t.setRowHeight(rowHeight);
        return t;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        JButton button = this.buildAddButton();
        buttonPanel.add(button);
        this.addAlignRight(button);
        button = this.buildRemoveButton();
        buttonPanel.add(button);
        this.addAlignRight(button);
        button = this.buildRenameButton();
        buttonPanel.add(button);
        this.addAlignRight(button);
        return buttonPanel;
    }

    private ColumnPairsPanel buildFieldAssociationsPanel() {
        return new ColumnPairsPanel(this.getWorkbenchContextHolder(), this.selectedReferenceHolder);
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("ADD_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ReferencesPropertiesPage.this.addReference();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addReference() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        ArrayList targetTables = new ArrayList(this.table().getDatabase().tablesSize());
        CollectionTools.addAll(targetTables, (Iterator)this.table().getDatabase().tables());
        CollectionTools.sort(targetTables);
        NewTableReferenceDialog dialog = NewTableReferenceDialog.buildReferenceDialogDisallowSourceTableSelection(this.getWorkbenchContext(), Collections.singletonList(this.selection()), targetTables);
        dialog.setSourceTable(this.table());
        dialog.setTargetTable((MWTable)targetTables.get(0));
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        MWReference reference = this.table().addReference(dialog.getReferenceName(), dialog.getTargetTable());
        reference.setOnDatabase(dialog.isOnDatabase());
        this.setSelectedReference(reference);
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ReferencesPropertiesPage.this.removeReference();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    void removeReference() {
        MWReference reference;
        int option;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_REFERENCES_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_REFERENCES_WARNING_DIALOG.title"), 0, 3)) == 0 && (reference = this.selectedReference()) != null) {
            this.table().removeReference(reference);
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        this.renameAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("RENAME_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("RENAME_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent event) {
                ReferencesPropertiesPage.this.renameReference();
            }
        };
        this.renameAction.setEnabled(false);
        return this.renameAction;
    }

    void renameReference() {
        String name;
        MWReference reference = this.selectedReference();
        if (reference != null && (name = this.getReferenceNameFromUser(reference.getName(), "RENAME_REFERENCE_DIALOG")) != null) {
            reference.setName(name);
            this.setSelectedReference(reference);
        }
    }

    private String getReferenceNameFromUser(String originalName, String messageKey) {
        NewNameDialog dialog = this.buildNewNameDialog(originalName, messageKey);
        dialog.show();
        return dialog.wasConfirmed() ? dialog.getNewName() : null;
    }

    private NewNameDialog buildNewNameDialog(String originalName, String messageKey) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.table().referenceNames());
        builder.setOriginalName(originalName);
        builder.setTextFieldDescription(this.resourceRepository().getString(messageKey + ".message"));
        builder.setTitle(this.resourceRepository().getString(messageKey + ".title"));
        builder.setHelpTopicId("dialog.referenceRename");
        return builder.buildDialog(this.getWorkbenchContext());
    }

    private ComboBoxTableCellRenderer buildTargetTableComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildTargetTableComboBoxModel(), this.buildTargetTableListCellRenderer());
    }

    private ComboBoxModel buildTargetTableComboBoxModel() {
        return new ComboBoxModelAdapter(this.targetTablesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildTargetTableListCellRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private MWReference selectedReference() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWReference)this.rowSelectionModel.getSelectedValue();
    }

    void setSelectedReference(MWReference reference) {
        this.rowSelectionModel.setSelectedValue(reference);
    }

    private MWTable table() {
        return (MWTable)this.getSelectionHolder().getValue();
    }

    public static class ReferencesColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 3;
        public static final int REFERENCE_NAME_COLUMN = 0;
        public static final int TARGET_TABLE_COLUMN = 1;
        public static final int ON_DATABASE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"REFERENCE_NAME_COLUMN_HEADER", "TARGET_TABLE_COLUMN_HEADER", "ON_DATABASE_COLUMN_HEADER"};

        protected ReferencesColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index != 0;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWReference reference = (MWReference)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildReferenceNameAdapter(reference), this.buildTargetTableAdapter(reference), this.buildOnDatabaseAdapter(reference)};
            return result;
        }

        private PropertyValueModel buildReferenceNameAdapter(MWReference reference) {
            return new PropertyAspectAdapter("name", (Model)reference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).getName();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWReference)this.subject).setName((String)value);
                }
            };
        }

        private PropertyValueModel buildTargetTableAdapter(MWReference reference) {
            PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter("targetTable", (Model)reference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).getTargetTable();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWReference)this.subject).setTargetTable((MWTable)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "qualifiedName");
        }

        private PropertyValueModel buildOnDatabaseAdapter(MWReference reference) {
            return new PropertyAspectAdapter("onDatabase", (Model)reference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).isOnDatabase();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWReference)this.subject).setOnDatabase(((Boolean)value).booleanValue());
                }
            };
        }
    }
}

